<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlugList StructType
 * @subpackage Structs
 */
class PlugList extends AbstractStructBase
{
    /**
     * The Plug
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Plug;
    /**
     * Constructor method for PlugList
     * @uses PlugList::setPlug()
     * @param string[] $plug
     */
    public function __construct(array $plug = array())
    {
        $this
            ->setPlug($plug);
    }
    /**
     * Get Plug value
     * @return string[]
     */
    public function getPlug()
    {
        return $this->Plug;
    }
    /**
     * Set Plug value
     * @uses \EnumType\PlugType::valueIsValid()
     * @uses \EnumType\PlugType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $plug
     * @return \StructType\PlugList
     */
    public function setPlug(array $plug = array())
    {
        $invalidValues = array();
        foreach ($plug as $plugListPlugItem) {
            if (!\EnumType\PlugType::valueIsValid($plugListPlugItem)) {
                $invalidValues[] = var_export($plugListPlugItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\PlugType::getValidValues())), __LINE__);
        }
        $this->Plug = $plug;
        return $this;
    }
    /**
     * Add item to Plug value
     * @uses \EnumType\PlugType::valueIsValid()
     * @uses \EnumType\PlugType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PlugList
     */
    public function addToPlug($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PlugType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PlugType::getValidValues())), __LINE__);
        }
        $this->Plug[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlugList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
