<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatorEvseDataType StructType
 * @subpackage Structs
 */
class OperatorEvseDataType extends AbstractStructBase
{
    /**
     * The OperatorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Za-z]{2}\*?[A-Za-z0-9]{3})|(\+?[0-9]{1,3}\*[0-9]{3,6})
     * @var string
     */
    public $OperatorID;
    /**
     * The OperatorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $OperatorName;
    /**
     * The EvseDataRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EvseDataRecordType[]
     */
    public $EvseDataRecord;
    /**
     * Constructor method for OperatorEvseDataType
     * @uses OperatorEvseDataType::setOperatorID()
     * @uses OperatorEvseDataType::setOperatorName()
     * @uses OperatorEvseDataType::setEvseDataRecord()
     * @param string $operatorID
     * @param string $operatorName
     * @param \StructType\EvseDataRecordType[] $evseDataRecord
     */
    public function __construct($operatorID = null, $operatorName = null, array $evseDataRecord = array())
    {
        $this
            ->setOperatorID($operatorID)
            ->setOperatorName($operatorName)
            ->setEvseDataRecord($evseDataRecord);
    }
    /**
     * Get OperatorID value
     * @return string
     */
    public function getOperatorID()
    {
        return $this->OperatorID;
    }
    /**
     * Set OperatorID value
     * @param string $operatorID
     * @return \StructType\OperatorEvseDataType
     */
    public function setOperatorID($operatorID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($operatorID) && !preg_match('/([A-Za-z]{2}\\*?[A-Za-z0-9]{3})|(\\+?[0-9]{1,3}\\*[0-9]{3,6})/', $operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Za-z]{2}\*?[A-Za-z0-9]{3})|(\+?[0-9]{1,3}\*[0-9]{3,6})", "%s" given', var_export($operatorID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatorID) && !is_string($operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorID)), __LINE__);
        }
        $this->OperatorID = $operatorID;
        return $this;
    }
    /**
     * Get OperatorName value
     * @return string|null
     */
    public function getOperatorName()
    {
        return $this->OperatorName;
    }
    /**
     * Set OperatorName value
     * @param string $operatorName
     * @return \StructType\OperatorEvseDataType
     */
    public function setOperatorName($operatorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operatorName) && strlen($operatorName) > 100) || (is_array($operatorName) && count($operatorName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($operatorName) ? strlen($operatorName) : count($operatorName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operatorName) && !is_string($operatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorName)), __LINE__);
        }
        $this->OperatorName = $operatorName;
        return $this;
    }
    /**
     * Get EvseDataRecord value
     * @return \StructType\EvseDataRecordType[]|null
     */
    public function getEvseDataRecord()
    {
        return $this->EvseDataRecord;
    }
    /**
     * Set EvseDataRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\EvseDataRecordType[] $evseDataRecord
     * @return \StructType\OperatorEvseDataType
     */
    public function setEvseDataRecord(array $evseDataRecord = array())
    {
        foreach ($evseDataRecord as $operatorEvseDataTypeEvseDataRecordItem) {
            // validation for constraint: itemType
            if (!$operatorEvseDataTypeEvseDataRecordItem instanceof \StructType\EvseDataRecordType) {
                throw new \InvalidArgumentException(sprintf('The EvseDataRecord property can only contain items of \StructType\EvseDataRecordType, "%s" given', is_object($operatorEvseDataTypeEvseDataRecordItem) ? get_class($operatorEvseDataTypeEvseDataRecordItem) : gettype($operatorEvseDataTypeEvseDataRecordItem)), __LINE__);
            }
        }
        $this->EvseDataRecord = $evseDataRecord;
        return $this;
    }
    /**
     * Add item to EvseDataRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\EvseDataRecordType $item
     * @return \StructType\OperatorEvseDataType
     */
    public function addToEvseDataRecord(\StructType\EvseDataRecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EvseDataRecordType) {
            throw new \InvalidArgumentException(sprintf('The EvseDataRecord property can only contain items of \StructType\EvseDataRecordType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EvseDataRecord[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatorEvseDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
