<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EvseData StructType
 * @subpackage Structs
 */
class EvseData extends AbstractStructBase
{
    /**
     * The OperatorEvseData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OperatorEvseDataType[]
     */
    public $OperatorEvseData;
    /**
     * Constructor method for EvseData
     * @uses EvseData::setOperatorEvseData()
     * @param \StructType\OperatorEvseDataType[] $operatorEvseData
     */
    public function __construct(array $operatorEvseData = array())
    {
        $this
            ->setOperatorEvseData($operatorEvseData);
    }
    /**
     * Get OperatorEvseData value
     * @return \StructType\OperatorEvseDataType[]|null
     */
    public function getOperatorEvseData()
    {
        return $this->OperatorEvseData;
    }
    /**
     * Set OperatorEvseData value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorEvseDataType[] $operatorEvseData
     * @return \StructType\EvseData
     */
    public function setOperatorEvseData(array $operatorEvseData = array())
    {
        foreach ($operatorEvseData as $evseDataOperatorEvseDataItem) {
            // validation for constraint: itemType
            if (!$evseDataOperatorEvseDataItem instanceof \StructType\OperatorEvseDataType) {
                throw new \InvalidArgumentException(sprintf('The OperatorEvseData property can only contain items of \StructType\OperatorEvseDataType, "%s" given', is_object($evseDataOperatorEvseDataItem) ? get_class($evseDataOperatorEvseDataItem) : gettype($evseDataOperatorEvseDataItem)), __LINE__);
            }
        }
        $this->OperatorEvseData = $operatorEvseData;
        return $this;
    }
    /**
     * Add item to OperatorEvseData value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorEvseDataType $item
     * @return \StructType\EvseData
     */
    public function addToOperatorEvseData(\StructType\OperatorEvseDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperatorEvseDataType) {
            throw new \InvalidArgumentException(sprintf('The OperatorEvseData property can only contain items of \StructType\OperatorEvseDataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperatorEvseData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EvseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
