<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eRoamingPushEvseData StructType
 * Meta informations extracted from the WSDL
 * - type: tns:eRoamingPushEvseData
 * @subpackage Structs
 */
class ERoamingPushEvseData extends AbstractStructBase
{
    /**
     * The ActionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ActionType;
    /**
     * The OperatorEvseData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OperatorEvseDataType
     */
    public $OperatorEvseData;
    /**
     * Constructor method for eRoamingPushEvseData
     * @uses ERoamingPushEvseData::setActionType()
     * @uses ERoamingPushEvseData::setOperatorEvseData()
     * @param string $actionType
     * @param \StructType\OperatorEvseDataType $operatorEvseData
     */
    public function __construct($actionType = null, \StructType\OperatorEvseDataType $operatorEvseData = null)
    {
        $this
            ->setActionType($actionType)
            ->setOperatorEvseData($operatorEvseData);
    }
    /**
     * Get ActionType value
     * @return string
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ERoamingPushEvseData
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get OperatorEvseData value
     * @return \StructType\OperatorEvseDataType
     */
    public function getOperatorEvseData()
    {
        return $this->OperatorEvseData;
    }
    /**
     * Set OperatorEvseData value
     * @param \StructType\OperatorEvseDataType $operatorEvseData
     * @return \StructType\ERoamingPushEvseData
     */
    public function setOperatorEvseData(\StructType\OperatorEvseDataType $operatorEvseData = null)
    {
        $this->OperatorEvseData = $operatorEvseData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ERoamingPushEvseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
