<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eRoamingGetEvseById StructType
 * Meta informations extracted from the WSDL
 * - type: tns:eRoamingGetEvseById
 * @subpackage Structs
 */
class ERoamingGetEvseById extends AbstractStructBase
{
    /**
     * The EvseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Za-z]{2}\*?[A-Za-z0-9]{3}\*?E[A-Za-z0-9\*]{1,30})|(\+?[0-9]{1,3}\*[0-9]{3,6}\*[0-9\*]{1,32})
     * @var string
     */
    public $EvseId;
    /**
     * Constructor method for eRoamingGetEvseById
     * @uses ERoamingGetEvseById::setEvseId()
     * @param string $evseId
     */
    public function __construct($evseId = null)
    {
        $this
            ->setEvseId($evseId);
    }
    /**
     * Get EvseId value
     * @return string
     */
    public function getEvseId()
    {
        return $this->EvseId;
    }
    /**
     * Set EvseId value
     * @param string $evseId
     * @return \StructType\ERoamingGetEvseById
     */
    public function setEvseId($evseId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($evseId) && !preg_match('/([A-Za-z]{2}\\*?[A-Za-z0-9]{3}\\*?E[A-Za-z0-9\\*]{1,30})|(\\+?[0-9]{1,3}\\*[0-9]{3,6}\\*[0-9\\*]{1,32})/', $evseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Za-z]{2}\*?[A-Za-z0-9]{3}\*?E[A-Za-z0-9\*]{1,30})|(\+?[0-9]{1,3}\*[0-9]{3,6}\*[0-9\*]{1,32})", "%s" given', var_export($evseId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($evseId) && !is_string($evseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($evseId)), __LINE__);
        }
        $this->EvseId = $evseId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ERoamingGetEvseById
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
