<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargingFacilityList StructType
 * @subpackage Structs
 */
class ChargingFacilityList extends AbstractStructBase
{
    /**
     * The ChargingFacility
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ChargingFacility;
    /**
     * Constructor method for ChargingFacilityList
     * @uses ChargingFacilityList::setChargingFacility()
     * @param string[] $chargingFacility
     */
    public function __construct(array $chargingFacility = array())
    {
        $this
            ->setChargingFacility($chargingFacility);
    }
    /**
     * Get ChargingFacility value
     * @return string[]
     */
    public function getChargingFacility()
    {
        return $this->ChargingFacility;
    }
    /**
     * Set ChargingFacility value
     * @uses \EnumType\ChargingFacilityType::valueIsValid()
     * @uses \EnumType\ChargingFacilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $chargingFacility
     * @return \StructType\ChargingFacilityList
     */
    public function setChargingFacility(array $chargingFacility = array())
    {
        $invalidValues = array();
        foreach ($chargingFacility as $chargingFacilityListChargingFacilityItem) {
            if (!\EnumType\ChargingFacilityType::valueIsValid($chargingFacilityListChargingFacilityItem)) {
                $invalidValues[] = var_export($chargingFacilityListChargingFacilityItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ChargingFacilityType::getValidValues())), __LINE__);
        }
        $this->ChargingFacility = $chargingFacility;
        return $this;
    }
    /**
     * Add item to ChargingFacility value
     * @uses \EnumType\ChargingFacilityType::valueIsValid()
     * @uses \EnumType\ChargingFacilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChargingFacilityList
     */
    public function addToChargingFacility($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargingFacilityType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ChargingFacilityType::getValidValues())), __LINE__);
        }
        $this->ChargingFacility[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargingFacilityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
