<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationModeList StructType
 * @subpackage Structs
 */
class AuthenticationModeList extends AbstractStructBase
{
    /**
     * The AuthenticationMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $AuthenticationMode;
    /**
     * Constructor method for AuthenticationModeList
     * @uses AuthenticationModeList::setAuthenticationMode()
     * @param string[] $authenticationMode
     */
    public function __construct(array $authenticationMode = array())
    {
        $this
            ->setAuthenticationMode($authenticationMode);
    }
    /**
     * Get AuthenticationMode value
     * @return string[]
     */
    public function getAuthenticationMode()
    {
        return $this->AuthenticationMode;
    }
    /**
     * Set AuthenticationMode value
     * @uses \EnumType\AuthenticationModeType::valueIsValid()
     * @uses \EnumType\AuthenticationModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $authenticationMode
     * @return \StructType\AuthenticationModeList
     */
    public function setAuthenticationMode(array $authenticationMode = array())
    {
        $invalidValues = array();
        foreach ($authenticationMode as $authenticationModeListAuthenticationModeItem) {
            if (!\EnumType\AuthenticationModeType::valueIsValid($authenticationModeListAuthenticationModeItem)) {
                $invalidValues[] = var_export($authenticationModeListAuthenticationModeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AuthenticationModeType::getValidValues())), __LINE__);
        }
        $this->AuthenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Add item to AuthenticationMode value
     * @uses \EnumType\AuthenticationModeType::valueIsValid()
     * @uses \EnumType\AuthenticationModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AuthenticationModeList
     */
    public function addToAuthenticationMode($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthenticationModeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AuthenticationModeType::getValidValues())), __LINE__);
        }
        $this->AuthenticationMode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticationModeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
