<?php

namespace EnumType;

/**
 * This class stands for GeoCoordinatesResponseFormatType EnumType
 * @subpackage Enumerations
 */
class GeoCoordinatesResponseFormatType
{
    /**
     * Constant for value 'Google'
     * @return string 'Google'
     */
    const VALUE_GOOGLE = 'Google';
    /**
     * Constant for value 'DegreeMinuteSeconds'
     * @return string 'DegreeMinuteSeconds'
     */
    const VALUE_DEGREE_MINUTE_SECONDS = 'DegreeMinuteSeconds';
    /**
     * Constant for value 'DecimalDegree'
     * @return string 'DecimalDegree'
     */
    const VALUE_DECIMAL_DEGREE = 'DecimalDegree';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GOOGLE
     * @uses self::VALUE_DEGREE_MINUTE_SECONDS
     * @uses self::VALUE_DECIMAL_DEGREE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GOOGLE,
            self::VALUE_DEGREE_MINUTE_SECONDS,
            self::VALUE_DECIMAL_DEGREE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
