<?php

namespace EnumType;

/**
 * This class stands for ChargingModeType EnumType
 * @subpackage Enumerations
 */
class ChargingModeType
{
    /**
     * Constant for value 'Mode_1'
     * @return string 'Mode_1'
     */
    const VALUE_MODE_1 = 'Mode_1';
    /**
     * Constant for value 'Mode_2'
     * @return string 'Mode_2'
     */
    const VALUE_MODE_2 = 'Mode_2';
    /**
     * Constant for value 'Mode_3'
     * @return string 'Mode_3'
     */
    const VALUE_MODE_3 = 'Mode_3';
    /**
     * Constant for value 'Mode_4'
     * @return string 'Mode_4'
     */
    const VALUE_MODE_4 = 'Mode_4';
    /**
     * Constant for value 'CHAdeMO'
     * @return string 'CHAdeMO'
     */
    const VALUE_CHADE_MO = 'CHAdeMO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MODE_1
     * @uses self::VALUE_MODE_2
     * @uses self::VALUE_MODE_3
     * @uses self::VALUE_MODE_4
     * @uses self::VALUE_CHADE_MO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MODE_1,
            self::VALUE_MODE_2,
            self::VALUE_MODE_3,
            self::VALUE_MODE_4,
            self::VALUE_CHADE_MO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
