<?php

namespace EnumType;

/**
 * This class stands for AuthenticationModeType EnumType
 * @subpackage Enumerations
 */
class AuthenticationModeType
{
    /**
     * Constant for value 'NFC RFID Classic'
     * @return string 'NFC RFID Classic'
     */
    const VALUE_NFC_RFID_CLASSIC = 'NFC RFID Classic';
    /**
     * Constant for value 'NFC RFID DESFire'
     * @return string 'NFC RFID DESFire'
     */
    const VALUE_NFC_RFID_DESFIRE = 'NFC RFID DESFire';
    /**
     * Constant for value 'PnC'
     * @return string 'PnC'
     */
    const VALUE_PN_C = 'PnC';
    /**
     * Constant for value 'REMOTE'
     * @return string 'REMOTE'
     */
    const VALUE_REMOTE = 'REMOTE';
    /**
     * Constant for value 'Direct Payment'
     * @return string 'Direct Payment'
     */
    const VALUE_DIRECT_PAYMENT = 'Direct Payment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NFC_RFID_CLASSIC
     * @uses self::VALUE_NFC_RFID_DESFIRE
     * @uses self::VALUE_PN_C
     * @uses self::VALUE_REMOTE
     * @uses self::VALUE_DIRECT_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NFC_RFID_CLASSIC,
            self::VALUE_NFC_RFID_DESFIRE,
            self::VALUE_PN_C,
            self::VALUE_REMOTE,
            self::VALUE_DIRECT_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
