<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://166.62.94.125/Mobpay/mobpay.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://166.62.94.125/Mobpay/mobpay.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \NetPayment\ClassMap::get(),
);
/**
 * Samples for Request ServiceType
 */
$request = new \NetPayment\ServiceType\Request($options);
/**
 * Sample call for RequestMoney operation/method
 */
if ($request->RequestMoney(new \NetPayment\StructType\RequestMoney()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \NetPayment\ServiceType\Send($options);
/**
 * Sample call for SendMoney operation/method
 */
if ($send->SendMoney(new \NetPayment\StructType\SendMoney()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMoneyManual operation/method
 */
if ($send->SendMoneyManual(new \NetPayment\StructType\SendMoneyManual()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSMS operation/method
 */
if ($send->SendSMS(new \NetPayment\StructType\SendSMS()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \NetPayment\ServiceType\Check($options);
/**
 * Sample call for CheckRequestMoneyStatus operation/method
 */
if ($check->CheckRequestMoneyStatus(new \NetPayment\StructType\CheckRequestMoneyStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \NetPayment\ServiceType\Get($options);
/**
 * Sample call for GetRequestStatus operation/method
 */
if ($get->GetRequestStatus(new \NetPayment\StructType\GetRequestStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
