<?php

namespace NetPayment\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendMoneyManual StructType
 * @subpackage Structs
 */
class SendMoneyManual extends AbstractStructBase
{
    /**
     * The _Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $_Amount;
    /**
     * The _MobileNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $_MobileNumber;
    /**
     * The _CustomerReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $_CustomerReference;
    /**
     * The _Username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $_Username;
    /**
     * The _Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $_Password;
    /**
     * The _newtorkID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $_newtorkID;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for SendMoneyManual
     * @uses SendMoneyManual::set_Amount()
     * @uses SendMoneyManual::set_MobileNumber()
     * @uses SendMoneyManual::set_CustomerReference()
     * @uses SendMoneyManual::set_Username()
     * @uses SendMoneyManual::set_Password()
     * @uses SendMoneyManual::set_newtorkID()
     * @uses SendMoneyManual::setTransactionID()
     * @param float $_Amount
     * @param string $_MobileNumber
     * @param string $_CustomerReference
     * @param string $_Username
     * @param string $_Password
     * @param int $_newtorkID
     * @param string $transactionID
     */
    public function __construct($_Amount = null, $_MobileNumber = null, $_CustomerReference = null, $_Username = null, $_Password = null, $_newtorkID = null, $transactionID = null)
    {
        $this
            ->set_Amount($_Amount)
            ->set_MobileNumber($_MobileNumber)
            ->set_CustomerReference($_CustomerReference)
            ->set_Username($_Username)
            ->set_Password($_Password)
            ->set_newtorkID($_newtorkID)
            ->setTransactionID($transactionID);
    }
    /**
     * Get _Amount value
     * @return float|null
     */
    public function get_Amount()
    {
        return $this->_Amount;
    }
    /**
     * Set _Amount value
     * @param float $_Amount
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function set_Amount($_Amount = null)
    {
        $this->_Amount = $_Amount;
        return $this;
    }
    /**
     * Get _MobileNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function get_MobileNumber()
    {
        return isset($this->_MobileNumber) ? $this->_MobileNumber : null;
    }
    /**
     * Set _MobileNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $_MobileNumber
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function set_MobileNumber($_MobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($_MobileNumber) && !is_string($_MobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_MobileNumber)), __LINE__);
        }
        if (is_null($_MobileNumber) || (is_array($_MobileNumber) && empty($_MobileNumber))) {
            unset($this->_MobileNumber);
        } else {
            $this->_MobileNumber = $_MobileNumber;
        }
        return $this;
    }
    /**
     * Get _CustomerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function get_CustomerReference()
    {
        return isset($this->_CustomerReference) ? $this->_CustomerReference : null;
    }
    /**
     * Set _CustomerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $_CustomerReference
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function set_CustomerReference($_CustomerReference = null)
    {
        // validation for constraint: string
        if (!is_null($_CustomerReference) && !is_string($_CustomerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_CustomerReference)), __LINE__);
        }
        if (is_null($_CustomerReference) || (is_array($_CustomerReference) && empty($_CustomerReference))) {
            unset($this->_CustomerReference);
        } else {
            $this->_CustomerReference = $_CustomerReference;
        }
        return $this;
    }
    /**
     * Get _Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function get_Username()
    {
        return isset($this->_Username) ? $this->_Username : null;
    }
    /**
     * Set _Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $_Username
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function set_Username($_Username = null)
    {
        // validation for constraint: string
        if (!is_null($_Username) && !is_string($_Username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_Username)), __LINE__);
        }
        if (is_null($_Username) || (is_array($_Username) && empty($_Username))) {
            unset($this->_Username);
        } else {
            $this->_Username = $_Username;
        }
        return $this;
    }
    /**
     * Get _Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function get_Password()
    {
        return isset($this->_Password) ? $this->_Password : null;
    }
    /**
     * Set _Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $_Password
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function set_Password($_Password = null)
    {
        // validation for constraint: string
        if (!is_null($_Password) && !is_string($_Password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_Password)), __LINE__);
        }
        if (is_null($_Password) || (is_array($_Password) && empty($_Password))) {
            unset($this->_Password);
        } else {
            $this->_Password = $_Password;
        }
        return $this;
    }
    /**
     * Get _newtorkID value
     * @return int|null
     */
    public function get_newtorkID()
    {
        return $this->_newtorkID;
    }
    /**
     * Set _newtorkID value
     * @param int $_newtorkID
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function set_newtorkID($_newtorkID = null)
    {
        // validation for constraint: int
        if (!is_null($_newtorkID) && !is_numeric($_newtorkID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($_newtorkID)), __LINE__);
        }
        $this->_newtorkID = $_newtorkID;
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionID
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NetPayment\StructType\SendMoneyManual
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
