<?php

namespace NetPayment\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendMoney
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NetPayment\StructType\SendMoney $parameters
     * @return \NetPayment\StructType\SendMoneyResponse|bool
     */
    public function SendMoney(\NetPayment\StructType\SendMoney $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendMoney($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMoneyManual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NetPayment\StructType\SendMoneyManual $parameters
     * @return \NetPayment\StructType\SendMoneyManualResponse|bool
     */
    public function SendMoneyManual(\NetPayment\StructType\SendMoneyManual $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendMoneyManual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSMS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NetPayment\StructType\SendSMS $parameters
     * @return \NetPayment\StructType\SendSMSResponse|bool
     */
    public function SendSMS(\NetPayment\StructType\SendSMS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendSMS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NetPayment\StructType\SendMoneyManualResponse|\NetPayment\StructType\SendMoneyResponse|\NetPayment\StructType\SendSMSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
