<?php

namespace NetPayment\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckRequestMoneyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NetPayment\StructType\CheckRequestMoneyStatus $parameters
     * @return \NetPayment\StructType\CheckRequestMoneyStatusResponse|bool
     */
    public function CheckRequestMoneyStatus(\NetPayment\StructType\CheckRequestMoneyStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CheckRequestMoneyStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NetPayment\StructType\CheckRequestMoneyStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
