<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://transinfobhn.ca/BPInfo/BPServices.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://transinfobhn.ca/BPInfo/BPServices.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Student ServiceType
 */
$student = new \ServiceType\Student($options);
/**
 * Sample call for StudentAuthenticates operation/method
 */
if ($student->StudentAuthenticates(new \StructType\StudentAuthenticates()) !== false) {
    print_r($student->getResult());
} else {
    print_r($student->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetStudentBasic operation/method
 */
if ($get->GetStudentBasic(new \StructType\GetStudentBasic()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentTransBasic operation/method
 */
if ($get->GetStudentTransBasic(new \StructType\GetStudentTransBasic()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentsWithTransChanges operation/method
 */
if ($get->GetStudentsWithTransChanges(new \StructType\GetStudentsWithTransChanges()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentsWhoHaveTravelCodeChanges operation/method
 */
if ($get->GetStudentsWhoHaveTravelCodeChanges(new \StructType\GetStudentsWhoHaveTravelCodeChanges()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStudentTransChangesXML operation/method
 */
if ($get->GetAllStudentTransChangesXML(new \StructType\GetAllStudentTransChangesXML()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentTransInformationXML operation/method
 */
if ($get->GetStudentTransInformationXML(new \StructType\GetStudentTransInformationXML()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentStandard operation/method
 */
if ($get->GetStudentStandard(new \StructType\GetStudentStandard()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllContactTypes operation/method
 */
if ($get->GetAllContactTypes(new \StructType\GetAllContactTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContacts operation/method
 */
if ($get->GetContacts(new \StructType\GetContacts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentComplete operation/method
 */
if ($get->GetStudentComplete(new \StructType\GetStudentComplete()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentsComplete operation/method
 */
if ($get->GetStudentsComplete(new \StructType\GetStudentsComplete()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllContacts operation/method
 */
if ($get->GetAllContacts(new \StructType\GetAllContacts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStudentStandard operation/method
 */
if ($get->GetAllStudentStandard(new \StructType\GetAllStudentStandard()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStudentComplete operation/method
 */
if ($get->GetAllStudentComplete(new \StructType\GetAllStudentComplete()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStudentStopAssignments operation/method
 */
if ($get->GetAllStudentStopAssignments(new \StructType\GetAllStudentStopAssignments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllHomeStops operation/method
 */
if ($get->GetAllHomeStops(new \StructType\GetAllHomeStops()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolStops operation/method
 */
if ($get->GetAllSchoolStops(new \StructType\GetAllSchoolStops()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllTransfers operation/method
 */
if ($get->GetAllTransfers(new \StructType\GetAllTransfers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSchoolsServicedByStop operation/method
 */
if ($get->GetSchoolsServicedByStop(new \StructType\GetSchoolsServicedByStop()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchools operation/method
 */
if ($get->GetAllSchools(new \StructType\GetAllSchools()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllRuns operation/method
 */
if ($get->GetAllRuns(new \StructType\GetAllRuns()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllRoutes operation/method
 */
if ($get->GetAllRoutes(new \StructType\GetAllRoutes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDistricts operation/method
 */
if ($get->GetAllDistricts(new \StructType\GetAllDistricts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllVehicles operation/method
 */
if ($get->GetAllVehicles(new \StructType\GetAllVehicles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllOperators operation/method
 */
if ($get->GetAllOperators(new \StructType\GetAllOperators()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDepots operation/method
 */
if ($get->GetAllDepots(new \StructType\GetAllDepots()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllGrades operation/method
 */
if ($get->GetAllGrades(new \StructType\GetAllGrades()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllPrograms operation/method
 */
if ($get->GetAllPrograms(new \StructType\GetAllPrograms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolProgramBellTimes operation/method
 */
if ($get->GetAllSchoolProgramBellTimes(new \StructType\GetAllSchoolProgramBellTimes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStudentPrograms operation/method
 */
if ($get->GetAllStudentPrograms(new \StructType\GetAllStudentPrograms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStudentRideTime operation/method
 */
if ($get->GetStudentRideTime(new \StructType\GetStudentRideTime()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllComponents operation/method
 */
if ($get->GetAllComponents(new \StructType\GetAllComponents()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWayPoints operation/method
 */
if ($get->GetWayPoints(new \StructType\GetWayPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllZoneTypes operation/method
 */
if ($get->GetAllZoneTypes(new \StructType\GetAllZoneTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllZonesByType operation/method
 */
if ($get->GetAllZonesByType(new \StructType\GetAllZonesByType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccidentCountForOperator operation/method
 */
if ($get->GetAccidentCountForOperator(new \StructType\GetAccidentCountForOperator()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIncidentCountForOperator operation/method
 */
if ($get->GetIncidentCountForOperator(new \StructType\GetIncidentCountForOperator()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllAccessPoints operation/method
 */
if ($get->GetAllAccessPoints(new \StructType\GetAllAccessPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllCorners operation/method
 */
if ($get->GetAllCorners(new \StructType\GetAllCorners()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDeadheads operation/method
 */
if ($get->GetAllDeadheads(new \StructType\GetAllDeadheads()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDeadheadWaypoints operation/method
 */
if ($get->GetAllDeadheadWaypoints(new \StructType\GetAllDeadheadWaypoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllExceptionBoundaries operation/method
 */
if ($get->GetAllExceptionBoundaries(new \StructType\GetAllExceptionBoundaries()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllExceptionBoundarySchools operation/method
 */
if ($get->GetAllExceptionBoundarySchools(new \StructType\GetAllExceptionBoundarySchools()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllExceptionBoundaryGrades operation/method
 */
if ($get->GetAllExceptionBoundaryGrades(new \StructType\GetAllExceptionBoundaryGrades()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllExceptionBoundaryPrograms operation/method
 */
if ($get->GetAllExceptionBoundaryPrograms(new \StructType\GetAllExceptionBoundaryPrograms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolBoundaries operation/method
 */
if ($get->GetAllSchoolBoundaries(new \StructType\GetAllSchoolBoundaries()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolBoundaryGrades operation/method
 */
if ($get->GetAllSchoolBoundaryGrades(new \StructType\GetAllSchoolBoundaryGrades()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolBoundaryPrograms operation/method
 */
if ($get->GetAllSchoolBoundaryPrograms(new \StructType\GetAllSchoolBoundaryPrograms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllLocations operation/method
 */
if ($get->GetAllLocations(new \StructType\GetAllLocations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDistricts_v2 operation/method
 */
if ($get->GetAllDistricts_v2(new \StructType\GetAllDistricts_v2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllRuns_v2 operation/method
 */
if ($get->GetAllRuns_v2(new \StructType\GetAllRuns_v2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolGrades operation/method
 */
if ($get->GetAllSchoolGrades(new \StructType\GetAllSchoolGrades()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchoolGradePrograms operation/method
 */
if ($get->GetAllSchoolGradePrograms(new \StructType\GetAllSchoolGradePrograms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllAddresses operation/method
 */
if ($get->GetAllAddresses(new \StructType\GetAllAddresses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllPolicies operation/method
 */
if ($get->GetAllPolicies(new \StructType\GetAllPolicies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllGPSRouteVehicles operation/method
 */
if ($get->GetAllGPSRouteVehicles(new \StructType\GetAllGPSRouteVehicles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSchools_v2 operation/method
 */
if ($get->GetAllSchools_v2(new \StructType\GetAllSchools_v2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllVehicleTypes operation/method
 */
if ($get->GetAllVehicleTypes(new \StructType\GetAllVehicleTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDrivers operation/method
 */
if ($get->GetAllDrivers(new \StructType\GetAllDrivers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllDriverSchedules operation/method
 */
if ($get->GetAllDriverSchedules(new \StructType\GetAllDriverSchedules()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDatabaseDescriptions operation/method
 */
if ($get->GetDatabaseDescriptions(new \StructType\GetDatabaseDescriptions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDatabaseGuid operation/method
 */
if ($get->GetDatabaseGuid(new \StructType\GetDatabaseGuid()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllRunPoints operation/method
 */
if ($get->GetAllRunPoints(new \StructType\GetAllRunPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRouteItinerary operation/method
 */
if ($get->GetRouteItinerary(new \StructType\GetRouteItinerary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStreetList operation/method
 */
if ($get->GetStreetList(new \StructType\GetStreetList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAddressEligibility operation/method
 */
if ($get->GetAddressEligibility(new \StructType\GetAddressEligibility()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListStudentTransBasic operation/method
 */
if ($list->ListStudentTransBasic(new \StructType\ListStudentTransBasic()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveGPSRouteVehicle operation/method
 */
if ($save->SaveGPSRouteVehicle(new \StructType\SaveGPSRouteVehicle()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteGPSRouteVehicle operation/method
 */
if ($delete->DeleteGPSRouteVehicle(new \StructType\DeleteGPSRouteVehicle()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
