<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zone StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Zone
 * @subpackage Structs
 */
class Zone extends AbstractStructBase
{
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ModifiedDate
     * @var string
     */
    public $ModifiedDate;
    /**
     * The Points
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPosition
     */
    public $Points;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The ZoneID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ZoneID;
    /**
     * The ZoneType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ZoneType;
    /**
     * Constructor method for Zone
     * @uses Zone::setActive()
     * @uses Zone::setCreatedDate()
     * @uses Zone::setDescription()
     * @uses Zone::setEffectiveDate()
     * @uses Zone::setModifiedDate()
     * @uses Zone::setPoints()
     * @uses Zone::setRetireDate()
     * @uses Zone::setZoneID()
     * @uses Zone::setZoneType()
     * @param bool $active
     * @param string $createdDate
     * @param string $description
     * @param string $effectiveDate
     * @param string $modifiedDate
     * @param \ArrayType\ArrayOfPosition $points
     * @param string $retireDate
     * @param string $zoneID
     * @param string $zoneType
     */
    public function __construct($active = null, $createdDate = null, $description = null, $effectiveDate = null, $modifiedDate = null, \ArrayType\ArrayOfPosition $points = null, $retireDate = null, $zoneID = null, $zoneType = null)
    {
        $this
            ->setActive($active)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setModifiedDate($modifiedDate)
            ->setPoints($points)
            ->setRetireDate($retireDate)
            ->setZoneID($zoneID)
            ->setZoneType($zoneType);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Zone
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Zone
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Zone
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Zone
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\Zone
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get Points value
     * @return \ArrayType\ArrayOfPosition|null
     */
    public function getPoints()
    {
        return $this->Points;
    }
    /**
     * Set Points value
     * @param \ArrayType\ArrayOfPosition $points
     * @return \StructType\Zone
     */
    public function setPoints(\ArrayType\ArrayOfPosition $points = null)
    {
        $this->Points = $points;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\Zone
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get ZoneID value
     * @return string|null
     */
    public function getZoneID()
    {
        return $this->ZoneID;
    }
    /**
     * Set ZoneID value
     * @param string $zoneID
     * @return \StructType\Zone
     */
    public function setZoneID($zoneID = null)
    {
        // validation for constraint: string
        if (!is_null($zoneID) && !is_string($zoneID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zoneID)), __LINE__);
        }
        $this->ZoneID = $zoneID;
        return $this;
    }
    /**
     * Get ZoneType value
     * @return string|null
     */
    public function getZoneType()
    {
        return $this->ZoneType;
    }
    /**
     * Set ZoneType value
     * @param string $zoneType
     * @return \StructType\Zone
     */
    public function setZoneType($zoneType = null)
    {
        // validation for constraint: string
        if (!is_null($zoneType) && !is_string($zoneType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zoneType)), __LINE__);
        }
        $this->ZoneType = $zoneType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Zone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
