<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelCode StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TravelCode
 * @subpackage Structs
 */
class TravelCode extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * The TransportationTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransportationTypeGuid;
    /**
     * The TravelCodeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TravelCodeGuid;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransportationType
     */
    public $Type;
    /**
     * Constructor method for TravelCode
     * @uses TravelCode::setCode()
     * @uses TravelCode::setDescription()
     * @uses TravelCode::setSortOrder()
     * @uses TravelCode::setTransportationTypeGuid()
     * @uses TravelCode::setTravelCodeGuid()
     * @uses TravelCode::setType()
     * @param string $code
     * @param string $description
     * @param int $sortOrder
     * @param string $transportationTypeGuid
     * @param string $travelCodeGuid
     * @param \StructType\TransportationType $type
     */
    public function __construct($code = null, $description = null, $sortOrder = null, $transportationTypeGuid = null, $travelCodeGuid = null, \StructType\TransportationType $type = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setSortOrder($sortOrder)
            ->setTransportationTypeGuid($transportationTypeGuid)
            ->setTravelCodeGuid($travelCodeGuid)
            ->setType($type);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\TravelCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\TravelCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\TravelCode
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get TransportationTypeGuid value
     * @return string|null
     */
    public function getTransportationTypeGuid()
    {
        return $this->TransportationTypeGuid;
    }
    /**
     * Set TransportationTypeGuid value
     * @param string $transportationTypeGuid
     * @return \StructType\TravelCode
     */
    public function setTransportationTypeGuid($transportationTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transportationTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transportationTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($transportationTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transportationTypeGuid) && !is_string($transportationTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportationTypeGuid)), __LINE__);
        }
        $this->TransportationTypeGuid = $transportationTypeGuid;
        return $this;
    }
    /**
     * Get TravelCodeGuid value
     * @return string|null
     */
    public function getTravelCodeGuid()
    {
        return $this->TravelCodeGuid;
    }
    /**
     * Set TravelCodeGuid value
     * @param string $travelCodeGuid
     * @return \StructType\TravelCode
     */
    public function setTravelCodeGuid($travelCodeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($travelCodeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $travelCodeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($travelCodeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($travelCodeGuid) && !is_string($travelCodeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelCodeGuid)), __LINE__);
        }
        $this->TravelCodeGuid = $travelCodeGuid;
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransportationType|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TransportationType $type
     * @return \StructType\TravelCode
     */
    public function setType(\StructType\TransportationType $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
