<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransportInfo
 * @subpackage Structs
 */
class TransportInfo extends AbstractStructBase
{
    /**
     * The BusOperator
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusOperator;
    /**
     * The BusOperatorPhone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusOperatorPhone;
    /**
     * The Pickups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBusStopStudentInfo
     */
    public $Pickups;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The Dropoffs
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfBusStopStudentInfo
     */
    public $Dropoffs;
    /**
     * Constructor method for TransportInfo
     * @uses TransportInfo::setBusOperator()
     * @uses TransportInfo::setBusOperatorPhone()
     * @uses TransportInfo::setPickups()
     * @uses TransportInfo::setRouteID()
     * @uses TransportInfo::setRunID()
     * @uses TransportInfo::setDropoffs()
     * @param string $busOperator
     * @param string $busOperatorPhone
     * @param \ArrayType\ArrayOfBusStopStudentInfo $pickups
     * @param string $routeID
     * @param string $runID
     * @param \ArrayType\ArrayOfBusStopStudentInfo $dropoffs
     */
    public function __construct($busOperator = null, $busOperatorPhone = null, \ArrayType\ArrayOfBusStopStudentInfo $pickups = null, $routeID = null, $runID = null, \ArrayType\ArrayOfBusStopStudentInfo $dropoffs = null)
    {
        $this
            ->setBusOperator($busOperator)
            ->setBusOperatorPhone($busOperatorPhone)
            ->setPickups($pickups)
            ->setRouteID($routeID)
            ->setRunID($runID)
            ->setDropoffs($dropoffs);
    }
    /**
     * Get BusOperator value
     * @return string|null
     */
    public function getBusOperator()
    {
        return $this->BusOperator;
    }
    /**
     * Set BusOperator value
     * @param string $busOperator
     * @return \StructType\TransportInfo
     */
    public function setBusOperator($busOperator = null)
    {
        // validation for constraint: string
        if (!is_null($busOperator) && !is_string($busOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busOperator)), __LINE__);
        }
        $this->BusOperator = $busOperator;
        return $this;
    }
    /**
     * Get BusOperatorPhone value
     * @return string|null
     */
    public function getBusOperatorPhone()
    {
        return $this->BusOperatorPhone;
    }
    /**
     * Set BusOperatorPhone value
     * @param string $busOperatorPhone
     * @return \StructType\TransportInfo
     */
    public function setBusOperatorPhone($busOperatorPhone = null)
    {
        // validation for constraint: string
        if (!is_null($busOperatorPhone) && !is_string($busOperatorPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busOperatorPhone)), __LINE__);
        }
        $this->BusOperatorPhone = $busOperatorPhone;
        return $this;
    }
    /**
     * Get Pickups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBusStopStudentInfo|null
     */
    public function getPickups()
    {
        return isset($this->Pickups) ? $this->Pickups : null;
    }
    /**
     * Set Pickups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBusStopStudentInfo $pickups
     * @return \StructType\TransportInfo
     */
    public function setPickups(\ArrayType\ArrayOfBusStopStudentInfo $pickups = null)
    {
        if (is_null($pickups) || (is_array($pickups) && empty($pickups))) {
            unset($this->Pickups);
        } else {
            $this->Pickups = $pickups;
        }
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\TransportInfo
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\TransportInfo
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get Dropoffs value
     * @return \ArrayType\ArrayOfBusStopStudentInfo|null
     */
    public function getDropoffs()
    {
        return $this->Dropoffs;
    }
    /**
     * Set Dropoffs value
     * @param \ArrayType\ArrayOfBusStopStudentInfo $dropoffs
     * @return \StructType\TransportInfo
     */
    public function setDropoffs(\ArrayType\ArrayOfBusStopStudentInfo $dropoffs = null)
    {
        $this->Dropoffs = $dropoffs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
