<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentStandard StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentStandard
 * @subpackage Structs
 */
class StudentStandard extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The AlternateID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AlternateID;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The DistrictID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistrictID;
    /**
     * The Eligibility
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Eligibility;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Grade;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The MetAtBus
     * @var bool
     */
    public $MetAtBus;
    /**
     * The ModifiedDate
     * @var string
     */
    public $ModifiedDate;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The Schedule
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Schedule;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The SchoolName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolName;
    /**
     * The SpecialEd
     * @var bool
     */
    public $SpecialEd;
    /**
     * The StudentGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StudentGuid;
    /**
     * The StudentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StudentID;
    /**
     * The TravelCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelCode;
    /**
     * The TravelDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelDescription;
    /**
     * Constructor method for StudentStandard
     * @uses StudentStandard::setAddress()
     * @uses StudentStandard::setAlternateID()
     * @uses StudentStandard::setBirthDate()
     * @uses StudentStandard::setCreatedDate()
     * @uses StudentStandard::setDistrictID()
     * @uses StudentStandard::setEligibility()
     * @uses StudentStandard::setFirstName()
     * @uses StudentStandard::setGender()
     * @uses StudentStandard::setGrade()
     * @uses StudentStandard::setLastName()
     * @uses StudentStandard::setLatLong()
     * @uses StudentStandard::setMetAtBus()
     * @uses StudentStandard::setModifiedDate()
     * @uses StudentStandard::setPhone()
     * @uses StudentStandard::setSIFGuid()
     * @uses StudentStandard::setSchedule()
     * @uses StudentStandard::setSchoolID()
     * @uses StudentStandard::setSchoolName()
     * @uses StudentStandard::setSpecialEd()
     * @uses StudentStandard::setStudentGuid()
     * @uses StudentStandard::setStudentID()
     * @uses StudentStandard::setTravelCode()
     * @uses StudentStandard::setTravelDescription()
     * @param \StructType\Address $address
     * @param string $alternateID
     * @param string $birthDate
     * @param string $createdDate
     * @param string $districtID
     * @param string $eligibility
     * @param string $firstName
     * @param string $gender
     * @param string $grade
     * @param string $lastName
     * @param \StructType\Position $latLong
     * @param bool $metAtBus
     * @param string $modifiedDate
     * @param string $phone
     * @param string $sIFGuid
     * @param string $schedule
     * @param string $schoolID
     * @param string $schoolName
     * @param bool $specialEd
     * @param string $studentGuid
     * @param string $studentID
     * @param string $travelCode
     * @param string $travelDescription
     */
    public function __construct(\StructType\Address $address = null, $alternateID = null, $birthDate = null, $createdDate = null, $districtID = null, $eligibility = null, $firstName = null, $gender = null, $grade = null, $lastName = null, \StructType\Position $latLong = null, $metAtBus = null, $modifiedDate = null, $phone = null, $sIFGuid = null, $schedule = null, $schoolID = null, $schoolName = null, $specialEd = null, $studentGuid = null, $studentID = null, $travelCode = null, $travelDescription = null)
    {
        $this
            ->setAddress($address)
            ->setAlternateID($alternateID)
            ->setBirthDate($birthDate)
            ->setCreatedDate($createdDate)
            ->setDistrictID($districtID)
            ->setEligibility($eligibility)
            ->setFirstName($firstName)
            ->setGender($gender)
            ->setGrade($grade)
            ->setLastName($lastName)
            ->setLatLong($latLong)
            ->setMetAtBus($metAtBus)
            ->setModifiedDate($modifiedDate)
            ->setPhone($phone)
            ->setSIFGuid($sIFGuid)
            ->setSchedule($schedule)
            ->setSchoolID($schoolID)
            ->setSchoolName($schoolName)
            ->setSpecialEd($specialEd)
            ->setStudentGuid($studentGuid)
            ->setStudentID($studentID)
            ->setTravelCode($travelCode)
            ->setTravelDescription($travelDescription);
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\StudentStandard
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get AlternateID value
     * @return string|null
     */
    public function getAlternateID()
    {
        return $this->AlternateID;
    }
    /**
     * Set AlternateID value
     * @param string $alternateID
     * @return \StructType\StudentStandard
     */
    public function setAlternateID($alternateID = null)
    {
        // validation for constraint: string
        if (!is_null($alternateID) && !is_string($alternateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternateID)), __LINE__);
        }
        $this->AlternateID = $alternateID;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\StudentStandard
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\StudentStandard
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get DistrictID value
     * @return string|null
     */
    public function getDistrictID()
    {
        return $this->DistrictID;
    }
    /**
     * Set DistrictID value
     * @param string $districtID
     * @return \StructType\StudentStandard
     */
    public function setDistrictID($districtID = null)
    {
        // validation for constraint: string
        if (!is_null($districtID) && !is_string($districtID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($districtID)), __LINE__);
        }
        $this->DistrictID = $districtID;
        return $this;
    }
    /**
     * Get Eligibility value
     * @return string|null
     */
    public function getEligibility()
    {
        return $this->Eligibility;
    }
    /**
     * Set Eligibility value
     * @param string $eligibility
     * @return \StructType\StudentStandard
     */
    public function setEligibility($eligibility = null)
    {
        // validation for constraint: string
        if (!is_null($eligibility) && !is_string($eligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eligibility)), __LINE__);
        }
        $this->Eligibility = $eligibility;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\StudentStandard
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\StudentStandard
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Grade value
     * @return string|null
     */
    public function getGrade()
    {
        return $this->Grade;
    }
    /**
     * Set Grade value
     * @param string $grade
     * @return \StructType\StudentStandard
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        $this->Grade = $grade;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\StudentStandard
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get LatLong value
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return $this->LatLong;
    }
    /**
     * Set LatLong value
     * @param \StructType\Position $latLong
     * @return \StructType\StudentStandard
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        $this->LatLong = $latLong;
        return $this;
    }
    /**
     * Get MetAtBus value
     * @return bool|null
     */
    public function getMetAtBus()
    {
        return $this->MetAtBus;
    }
    /**
     * Set MetAtBus value
     * @param bool $metAtBus
     * @return \StructType\StudentStandard
     */
    public function setMetAtBus($metAtBus = null)
    {
        // validation for constraint: boolean
        if (!is_null($metAtBus) && !is_bool($metAtBus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($metAtBus)), __LINE__);
        }
        $this->MetAtBus = $metAtBus;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\StudentStandard
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\StudentStandard
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\StudentStandard
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get Schedule value
     * @return string|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param string $schedule
     * @return \StructType\StudentStandard
     */
    public function setSchedule($schedule = null)
    {
        // validation for constraint: string
        if (!is_null($schedule) && !is_string($schedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schedule)), __LINE__);
        }
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get SchoolID value
     * @return string|null
     */
    public function getSchoolID()
    {
        return $this->SchoolID;
    }
    /**
     * Set SchoolID value
     * @param string $schoolID
     * @return \StructType\StudentStandard
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        $this->SchoolID = $schoolID;
        return $this;
    }
    /**
     * Get SchoolName value
     * @return string|null
     */
    public function getSchoolName()
    {
        return $this->SchoolName;
    }
    /**
     * Set SchoolName value
     * @param string $schoolName
     * @return \StructType\StudentStandard
     */
    public function setSchoolName($schoolName = null)
    {
        // validation for constraint: string
        if (!is_null($schoolName) && !is_string($schoolName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolName)), __LINE__);
        }
        $this->SchoolName = $schoolName;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\StudentStandard
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Get StudentGuid value
     * @return string|null
     */
    public function getStudentGuid()
    {
        return $this->StudentGuid;
    }
    /**
     * Set StudentGuid value
     * @param string $studentGuid
     * @return \StructType\StudentStandard
     */
    public function setStudentGuid($studentGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($studentGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $studentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($studentGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($studentGuid) && !is_string($studentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentGuid)), __LINE__);
        }
        $this->StudentGuid = $studentGuid;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \StructType\StudentStandard
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return string|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param string $travelCode
     * @return \StructType\StudentStandard
     */
    public function setTravelCode($travelCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelCode) && !is_string($travelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelCode)), __LINE__);
        }
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get TravelDescription value
     * @return string|null
     */
    public function getTravelDescription()
    {
        return $this->TravelDescription;
    }
    /**
     * Set TravelDescription value
     * @param string $travelDescription
     * @return \StructType\StudentStandard
     */
    public function setTravelDescription($travelDescription = null)
    {
        // validation for constraint: string
        if (!is_null($travelDescription) && !is_string($travelDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelDescription)), __LINE__);
        }
        $this->TravelDescription = $travelDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentStandard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
