<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentRide StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentRide
 * @subpackage Structs
 */
class StudentRide extends AbstractStructBase
{
    /**
     * The RideDistance
     * @var float
     */
    public $RideDistance;
    /**
     * The RideTime
     * @var int
     */
    public $RideTime;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The StudentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StudentID;
    /**
     * Constructor method for StudentRide
     * @uses StudentRide::setRideDistance()
     * @uses StudentRide::setRideTime()
     * @uses StudentRide::setRunID()
     * @uses StudentRide::setStudentID()
     * @param float $rideDistance
     * @param int $rideTime
     * @param string $runID
     * @param string $studentID
     */
    public function __construct($rideDistance = null, $rideTime = null, $runID = null, $studentID = null)
    {
        $this
            ->setRideDistance($rideDistance)
            ->setRideTime($rideTime)
            ->setRunID($runID)
            ->setStudentID($studentID);
    }
    /**
     * Get RideDistance value
     * @return float|null
     */
    public function getRideDistance()
    {
        return $this->RideDistance;
    }
    /**
     * Set RideDistance value
     * @param float $rideDistance
     * @return \StructType\StudentRide
     */
    public function setRideDistance($rideDistance = null)
    {
        $this->RideDistance = $rideDistance;
        return $this;
    }
    /**
     * Get RideTime value
     * @return int|null
     */
    public function getRideTime()
    {
        return $this->RideTime;
    }
    /**
     * Set RideTime value
     * @param int $rideTime
     * @return \StructType\StudentRide
     */
    public function setRideTime($rideTime = null)
    {
        // validation for constraint: int
        if (!is_null($rideTime) && !is_numeric($rideTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rideTime)), __LINE__);
        }
        $this->RideTime = $rideTime;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\StudentRide
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \StructType\StudentRide
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentRide
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
