<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentEligibility StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentEligibility
 * @subpackage Structs
 */
class StudentEligibility extends AbstractStructBase
{
    /**
     * The AddressType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AddressType;
    /**
     * The Distance
     * @var float
     */
    public $Distance;
    /**
     * The Eligibility
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Eligibility;
    /**
     * The TravelCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TravelCode;
    /**
     * The AddressGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressGuid;
    /**
     * The EnrollmentGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentGuid;
    /**
     * Constructor method for StudentEligibility
     * @uses StudentEligibility::setAddressType()
     * @uses StudentEligibility::setDistance()
     * @uses StudentEligibility::setEligibility()
     * @uses StudentEligibility::setTravelCode()
     * @uses StudentEligibility::setAddressGuid()
     * @uses StudentEligibility::setEnrollmentGuid()
     * @param string $addressType
     * @param float $distance
     * @param string $eligibility
     * @param string $travelCode
     * @param string $addressGuid
     * @param string $enrollmentGuid
     */
    public function __construct($addressType = null, $distance = null, $eligibility = null, $travelCode = null, $addressGuid = null, $enrollmentGuid = null)
    {
        $this
            ->setAddressType($addressType)
            ->setDistance($distance)
            ->setEligibility($eligibility)
            ->setTravelCode($travelCode)
            ->setAddressGuid($addressGuid)
            ->setEnrollmentGuid($enrollmentGuid);
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \StructType\StudentEligibility
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get Distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\StudentEligibility
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Eligibility value
     * @return string|null
     */
    public function getEligibility()
    {
        return $this->Eligibility;
    }
    /**
     * Set Eligibility value
     * @param string $eligibility
     * @return \StructType\StudentEligibility
     */
    public function setEligibility($eligibility = null)
    {
        // validation for constraint: string
        if (!is_null($eligibility) && !is_string($eligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eligibility)), __LINE__);
        }
        $this->Eligibility = $eligibility;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return string|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param string $travelCode
     * @return \StructType\StudentEligibility
     */
    public function setTravelCode($travelCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelCode) && !is_string($travelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelCode)), __LINE__);
        }
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get AddressGuid value
     * @return string|null
     */
    public function getAddressGuid()
    {
        return $this->AddressGuid;
    }
    /**
     * Set AddressGuid value
     * @param string $addressGuid
     * @return \StructType\StudentEligibility
     */
    public function setAddressGuid($addressGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addressGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addressGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressGuid) && !is_string($addressGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressGuid)), __LINE__);
        }
        $this->AddressGuid = $addressGuid;
        return $this;
    }
    /**
     * Get EnrollmentGuid value
     * @return string|null
     */
    public function getEnrollmentGuid()
    {
        return $this->EnrollmentGuid;
    }
    /**
     * Set EnrollmentGuid value
     * @param string $enrollmentGuid
     * @return \StructType\StudentEligibility
     */
    public function setEnrollmentGuid($enrollmentGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enrollmentGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($enrollmentGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enrollmentGuid) && !is_string($enrollmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollmentGuid)), __LINE__);
        }
        $this->EnrollmentGuid = $enrollmentGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentEligibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
