<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentComplete StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentComplete
 * @subpackage Structs
 */
class StudentComplete extends AbstractStructBase
{
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContact
     */
    public $Contacts;
    /**
     * The Enrollments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEnrollment
     */
    public $Enrollments;
    /**
     * The StudentInformation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\StudentStandard
     */
    public $StudentInformation;
    /**
     * The Trips
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfTrip
     */
    public $Trips;
    /**
     * Constructor method for StudentComplete
     * @uses StudentComplete::setContacts()
     * @uses StudentComplete::setEnrollments()
     * @uses StudentComplete::setStudentInformation()
     * @uses StudentComplete::setTrips()
     * @param \ArrayType\ArrayOfContact $contacts
     * @param \ArrayType\ArrayOfEnrollment $enrollments
     * @param \StructType\StudentStandard $studentInformation
     * @param \ArrayType\ArrayOfTrip $trips
     */
    public function __construct(\ArrayType\ArrayOfContact $contacts = null, \ArrayType\ArrayOfEnrollment $enrollments = null, \StructType\StudentStandard $studentInformation = null, \ArrayType\ArrayOfTrip $trips = null)
    {
        $this
            ->setContacts($contacts)
            ->setEnrollments($enrollments)
            ->setStudentInformation($studentInformation)
            ->setTrips($trips);
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContact|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContact $contacts
     * @return \StructType\StudentComplete
     */
    public function setContacts(\ArrayType\ArrayOfContact $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get Enrollments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEnrollment|null
     */
    public function getEnrollments()
    {
        return isset($this->Enrollments) ? $this->Enrollments : null;
    }
    /**
     * Set Enrollments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEnrollment $enrollments
     * @return \StructType\StudentComplete
     */
    public function setEnrollments(\ArrayType\ArrayOfEnrollment $enrollments = null)
    {
        if (is_null($enrollments) || (is_array($enrollments) && empty($enrollments))) {
            unset($this->Enrollments);
        } else {
            $this->Enrollments = $enrollments;
        }
        return $this;
    }
    /**
     * Get StudentInformation value
     * @return \StructType\StudentStandard|null
     */
    public function getStudentInformation()
    {
        return $this->StudentInformation;
    }
    /**
     * Set StudentInformation value
     * @param \StructType\StudentStandard $studentInformation
     * @return \StructType\StudentComplete
     */
    public function setStudentInformation(\StructType\StudentStandard $studentInformation = null)
    {
        $this->StudentInformation = $studentInformation;
        return $this;
    }
    /**
     * Get Trips value
     * @return \ArrayType\ArrayOfTrip|null
     */
    public function getTrips()
    {
        return $this->Trips;
    }
    /**
     * Set Trips value
     * @param \ArrayType\ArrayOfTrip $trips
     * @return \StructType\StudentComplete
     */
    public function setTrips(\ArrayType\ArrayOfTrip $trips = null)
    {
        $this->Trips = $trips;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentComplete
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
