<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentBasic StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StudentBasic
 * @subpackage Structs
 */
class StudentBasic extends AbstractStructBase
{
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The SchoolName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolName;
    /**
     * The StudentID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $StudentID;
    /**
     * Constructor method for StudentBasic
     * @uses StudentBasic::setBirthDate()
     * @uses StudentBasic::setFirstName()
     * @uses StudentBasic::setLastName()
     * @uses StudentBasic::setSchoolName()
     * @uses StudentBasic::setStudentID()
     * @param string $birthDate
     * @param string $firstName
     * @param string $lastName
     * @param string $schoolName
     * @param string $studentID
     */
    public function __construct($birthDate = null, $firstName = null, $lastName = null, $schoolName = null, $studentID = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSchoolName($schoolName)
            ->setStudentID($studentID);
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\StudentBasic
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\StudentBasic
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\StudentBasic
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get SchoolName value
     * @return string|null
     */
    public function getSchoolName()
    {
        return $this->SchoolName;
    }
    /**
     * Set SchoolName value
     * @param string $schoolName
     * @return \StructType\StudentBasic
     */
    public function setSchoolName($schoolName = null)
    {
        // validation for constraint: string
        if (!is_null($schoolName) && !is_string($schoolName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolName)), __LINE__);
        }
        $this->SchoolName = $schoolName;
        return $this;
    }
    /**
     * Get StudentID value
     * @return string|null
     */
    public function getStudentID()
    {
        return $this->StudentID;
    }
    /**
     * Set StudentID value
     * @param string $studentID
     * @return \StructType\StudentBasic
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        $this->StudentID = $studentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentBasic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
