<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopSchool StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StopSchool
 * @subpackage Structs
 */
class StopSchool extends AbstractStructBase
{
    /**
     * The BusStopID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BusStopID;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The StopType
     * @var string
     */
    public $StopType;
    /**
     * Constructor method for StopSchool
     * @uses StopSchool::setBusStopID()
     * @uses StopSchool::setSchoolID()
     * @uses StopSchool::setStopType()
     * @param string $busStopID
     * @param string $schoolID
     * @param string $stopType
     */
    public function __construct($busStopID = null, $schoolID = null, $stopType = null)
    {
        $this
            ->setBusStopID($busStopID)
            ->setSchoolID($schoolID)
            ->setStopType($stopType);
    }
    /**
     * Get BusStopID value
     * @return string|null
     */
    public function getBusStopID()
    {
        return $this->BusStopID;
    }
    /**
     * Set BusStopID value
     * @param string $busStopID
     * @return \StructType\StopSchool
     */
    public function setBusStopID($busStopID = null)
    {
        // validation for constraint: string
        if (!is_null($busStopID) && !is_string($busStopID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($busStopID)), __LINE__);
        }
        $this->BusStopID = $busStopID;
        return $this;
    }
    /**
     * Get SchoolID value
     * @return string|null
     */
    public function getSchoolID()
    {
        return $this->SchoolID;
    }
    /**
     * Set SchoolID value
     * @param string $schoolID
     * @return \StructType\StopSchool
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        $this->SchoolID = $schoolID;
        return $this;
    }
    /**
     * Get StopType value
     * @return string|null
     */
    public function getStopType()
    {
        return $this->StopType;
    }
    /**
     * Set StopType value
     * @uses \EnumType\BusStopType::valueIsValid()
     * @uses \EnumType\BusStopType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopType
     * @return \StructType\StopSchool
     */
    public function setStopType($stopType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusStopType::valueIsValid($stopType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopType, implode(', ', \EnumType\BusStopType::getValidValues())), __LINE__);
        }
        $this->StopType = $stopType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopSchool
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
