<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchoolBoundaryProgram StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SchoolBoundaryProgram
 * @subpackage Structs
 */
class SchoolBoundaryProgram extends AbstractStructBase
{
    /**
     * The Exclude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ProgramGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProgramGuid;
    /**
     * The SchoolBoundaryGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolBoundaryGuid;
    /**
     * The SchoolBoundaryID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolBoundaryID;
    /**
     * The SchoolBoundaryProgramGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolBoundaryProgramGuid;
    /**
     * Constructor method for SchoolBoundaryProgram
     * @uses SchoolBoundaryProgram::setExclude()
     * @uses SchoolBoundaryProgram::setID()
     * @uses SchoolBoundaryProgram::setName()
     * @uses SchoolBoundaryProgram::setProgramGuid()
     * @uses SchoolBoundaryProgram::setSchoolBoundaryGuid()
     * @uses SchoolBoundaryProgram::setSchoolBoundaryID()
     * @uses SchoolBoundaryProgram::setSchoolBoundaryProgramGuid()
     * @param bool $exclude
     * @param \StructType\BPID $iD
     * @param string $name
     * @param string $programGuid
     * @param string $schoolBoundaryGuid
     * @param string $schoolBoundaryID
     * @param string $schoolBoundaryProgramGuid
     */
    public function __construct($exclude = null, \StructType\BPID $iD = null, $name = null, $programGuid = null, $schoolBoundaryGuid = null, $schoolBoundaryID = null, $schoolBoundaryProgramGuid = null)
    {
        $this
            ->setExclude($exclude)
            ->setID($iD)
            ->setName($name)
            ->setProgramGuid($programGuid)
            ->setSchoolBoundaryGuid($schoolBoundaryGuid)
            ->setSchoolBoundaryID($schoolBoundaryID)
            ->setSchoolBoundaryProgramGuid($schoolBoundaryProgramGuid);
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setExclude($exclude = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude) && !is_bool($exclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exclude)), __LINE__);
        }
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ProgramGuid value
     * @return string|null
     */
    public function getProgramGuid()
    {
        return $this->ProgramGuid;
    }
    /**
     * Set ProgramGuid value
     * @param string $programGuid
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setProgramGuid($programGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($programGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $programGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($programGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($programGuid) && !is_string($programGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programGuid)), __LINE__);
        }
        $this->ProgramGuid = $programGuid;
        return $this;
    }
    /**
     * Get SchoolBoundaryGuid value
     * @return string|null
     */
    public function getSchoolBoundaryGuid()
    {
        return $this->SchoolBoundaryGuid;
    }
    /**
     * Set SchoolBoundaryGuid value
     * @param string $schoolBoundaryGuid
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setSchoolBoundaryGuid($schoolBoundaryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolBoundaryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolBoundaryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolBoundaryGuid) && !is_string($schoolBoundaryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryGuid)), __LINE__);
        }
        $this->SchoolBoundaryGuid = $schoolBoundaryGuid;
        return $this;
    }
    /**
     * Get SchoolBoundaryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolBoundaryID()
    {
        return isset($this->SchoolBoundaryID) ? $this->SchoolBoundaryID : null;
    }
    /**
     * Set SchoolBoundaryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolBoundaryID
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setSchoolBoundaryID($schoolBoundaryID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolBoundaryID) && !is_string($schoolBoundaryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryID)), __LINE__);
        }
        if (is_null($schoolBoundaryID) || (is_array($schoolBoundaryID) && empty($schoolBoundaryID))) {
            unset($this->SchoolBoundaryID);
        } else {
            $this->SchoolBoundaryID = $schoolBoundaryID;
        }
        return $this;
    }
    /**
     * Get SchoolBoundaryProgramGuid value
     * @return string|null
     */
    public function getSchoolBoundaryProgramGuid()
    {
        return $this->SchoolBoundaryProgramGuid;
    }
    /**
     * Set SchoolBoundaryProgramGuid value
     * @param string $schoolBoundaryProgramGuid
     * @return \StructType\SchoolBoundaryProgram
     */
    public function setSchoolBoundaryProgramGuid($schoolBoundaryProgramGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolBoundaryProgramGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolBoundaryProgramGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolBoundaryProgramGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolBoundaryProgramGuid) && !is_string($schoolBoundaryProgramGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolBoundaryProgramGuid)), __LINE__);
        }
        $this->SchoolBoundaryProgramGuid = $schoolBoundaryProgramGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SchoolBoundaryProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
