<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for School StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:School
 * @subpackage Structs
 */
class School extends AbstractStructBase
{
    /**
     * The AMBellTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AMBellTime;
    /**
     * The AMEarlyArrivalTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AMEarlyArrivalTime;
    /**
     * The AMLateArrivalTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AMLateArrivalTime;
    /**
     * The DistrictID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DistrictID;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PMBellTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PMBellTime;
    /**
     * The PMEarlyDepartureTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PMEarlyDepartureTime;
    /**
     * The PMLateDepartureTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PMLateDepartureTime;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The AlternateID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateID;
    /**
     * The TransportAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransportAddress;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address_v2
     */
    public $Address;
    /**
     * The Capacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Capacity;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The GradeSchoolTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeSchoolTypeGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The Public
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Public;
    /**
     * The Regular
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Regular;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SIFGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SIFGuid;
    /**
     * The SchoolGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchoolGuid;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GradeSchoolType
     */
    public $Type;
    /**
     * The WebPage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebPage;
    /**
     * Constructor method for School
     * @uses School::setAMBellTime()
     * @uses School::setAMEarlyArrivalTime()
     * @uses School::setAMLateArrivalTime()
     * @uses School::setDistrictID()
     * @uses School::setLatLong()
     * @uses School::setName()
     * @uses School::setPMBellTime()
     * @uses School::setPMEarlyDepartureTime()
     * @uses School::setPMLateDepartureTime()
     * @uses School::setSchoolID()
     * @uses School::setAlternateID()
     * @uses School::setTransportAddress()
     * @uses School::setActive()
     * @uses School::setAddress()
     * @uses School::setCapacity()
     * @uses School::setEffectiveDate()
     * @uses School::setGradeSchoolTypeGuid()
     * @uses School::setID()
     * @uses School::setProtected()
     * @uses School::setPublic()
     * @uses School::setRegular()
     * @uses School::setRetireDate()
     * @uses School::setSIFGuid()
     * @uses School::setSchoolGuid()
     * @uses School::setSpecialEd()
     * @uses School::setType()
     * @uses School::setWebPage()
     * @param string $aMBellTime
     * @param string $aMEarlyArrivalTime
     * @param string $aMLateArrivalTime
     * @param string $districtID
     * @param \StructType\Position $latLong
     * @param string $name
     * @param string $pMBellTime
     * @param string $pMEarlyDepartureTime
     * @param string $pMLateDepartureTime
     * @param string $schoolID
     * @param string $alternateID
     * @param string $transportAddress
     * @param bool $active
     * @param \StructType\Address_v2 $address
     * @param int $capacity
     * @param string $effectiveDate
     * @param string $gradeSchoolTypeGuid
     * @param \StructType\BPID $iD
     * @param bool $protected
     * @param bool $public
     * @param bool $regular
     * @param string $retireDate
     * @param string $sIFGuid
     * @param string $schoolGuid
     * @param bool $specialEd
     * @param \StructType\GradeSchoolType $type
     * @param string $webPage
     */
    public function __construct($aMBellTime = null, $aMEarlyArrivalTime = null, $aMLateArrivalTime = null, $districtID = null, \StructType\Position $latLong = null, $name = null, $pMBellTime = null, $pMEarlyDepartureTime = null, $pMLateDepartureTime = null, $schoolID = null, $alternateID = null, $transportAddress = null, $active = null, \StructType\Address_v2 $address = null, $capacity = null, $effectiveDate = null, $gradeSchoolTypeGuid = null, \StructType\BPID $iD = null, $protected = null, $public = null, $regular = null, $retireDate = null, $sIFGuid = null, $schoolGuid = null, $specialEd = null, \StructType\GradeSchoolType $type = null, $webPage = null)
    {
        $this
            ->setAMBellTime($aMBellTime)
            ->setAMEarlyArrivalTime($aMEarlyArrivalTime)
            ->setAMLateArrivalTime($aMLateArrivalTime)
            ->setDistrictID($districtID)
            ->setLatLong($latLong)
            ->setName($name)
            ->setPMBellTime($pMBellTime)
            ->setPMEarlyDepartureTime($pMEarlyDepartureTime)
            ->setPMLateDepartureTime($pMLateDepartureTime)
            ->setSchoolID($schoolID)
            ->setAlternateID($alternateID)
            ->setTransportAddress($transportAddress)
            ->setActive($active)
            ->setAddress($address)
            ->setCapacity($capacity)
            ->setEffectiveDate($effectiveDate)
            ->setGradeSchoolTypeGuid($gradeSchoolTypeGuid)
            ->setID($iD)
            ->setProtected($protected)
            ->setPublic($public)
            ->setRegular($regular)
            ->setRetireDate($retireDate)
            ->setSIFGuid($sIFGuid)
            ->setSchoolGuid($schoolGuid)
            ->setSpecialEd($specialEd)
            ->setType($type)
            ->setWebPage($webPage);
    }
    /**
     * Get AMBellTime value
     * @return string|null
     */
    public function getAMBellTime()
    {
        return $this->AMBellTime;
    }
    /**
     * Set AMBellTime value
     * @param string $aMBellTime
     * @return \StructType\School
     */
    public function setAMBellTime($aMBellTime = null)
    {
        // validation for constraint: string
        if (!is_null($aMBellTime) && !is_string($aMBellTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aMBellTime)), __LINE__);
        }
        $this->AMBellTime = $aMBellTime;
        return $this;
    }
    /**
     * Get AMEarlyArrivalTime value
     * @return string|null
     */
    public function getAMEarlyArrivalTime()
    {
        return $this->AMEarlyArrivalTime;
    }
    /**
     * Set AMEarlyArrivalTime value
     * @param string $aMEarlyArrivalTime
     * @return \StructType\School
     */
    public function setAMEarlyArrivalTime($aMEarlyArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aMEarlyArrivalTime) && !is_string($aMEarlyArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aMEarlyArrivalTime)), __LINE__);
        }
        $this->AMEarlyArrivalTime = $aMEarlyArrivalTime;
        return $this;
    }
    /**
     * Get AMLateArrivalTime value
     * @return string|null
     */
    public function getAMLateArrivalTime()
    {
        return $this->AMLateArrivalTime;
    }
    /**
     * Set AMLateArrivalTime value
     * @param string $aMLateArrivalTime
     * @return \StructType\School
     */
    public function setAMLateArrivalTime($aMLateArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aMLateArrivalTime) && !is_string($aMLateArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aMLateArrivalTime)), __LINE__);
        }
        $this->AMLateArrivalTime = $aMLateArrivalTime;
        return $this;
    }
    /**
     * Get DistrictID value
     * @return string|null
     */
    public function getDistrictID()
    {
        return $this->DistrictID;
    }
    /**
     * Set DistrictID value
     * @param string $districtID
     * @return \StructType\School
     */
    public function setDistrictID($districtID = null)
    {
        // validation for constraint: string
        if (!is_null($districtID) && !is_string($districtID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($districtID)), __LINE__);
        }
        $this->DistrictID = $districtID;
        return $this;
    }
    /**
     * Get LatLong value
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return $this->LatLong;
    }
    /**
     * Set LatLong value
     * @param \StructType\Position $latLong
     * @return \StructType\School
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        $this->LatLong = $latLong;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\School
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PMBellTime value
     * @return string|null
     */
    public function getPMBellTime()
    {
        return $this->PMBellTime;
    }
    /**
     * Set PMBellTime value
     * @param string $pMBellTime
     * @return \StructType\School
     */
    public function setPMBellTime($pMBellTime = null)
    {
        // validation for constraint: string
        if (!is_null($pMBellTime) && !is_string($pMBellTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pMBellTime)), __LINE__);
        }
        $this->PMBellTime = $pMBellTime;
        return $this;
    }
    /**
     * Get PMEarlyDepartureTime value
     * @return string|null
     */
    public function getPMEarlyDepartureTime()
    {
        return $this->PMEarlyDepartureTime;
    }
    /**
     * Set PMEarlyDepartureTime value
     * @param string $pMEarlyDepartureTime
     * @return \StructType\School
     */
    public function setPMEarlyDepartureTime($pMEarlyDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($pMEarlyDepartureTime) && !is_string($pMEarlyDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pMEarlyDepartureTime)), __LINE__);
        }
        $this->PMEarlyDepartureTime = $pMEarlyDepartureTime;
        return $this;
    }
    /**
     * Get PMLateDepartureTime value
     * @return string|null
     */
    public function getPMLateDepartureTime()
    {
        return $this->PMLateDepartureTime;
    }
    /**
     * Set PMLateDepartureTime value
     * @param string $pMLateDepartureTime
     * @return \StructType\School
     */
    public function setPMLateDepartureTime($pMLateDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($pMLateDepartureTime) && !is_string($pMLateDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pMLateDepartureTime)), __LINE__);
        }
        $this->PMLateDepartureTime = $pMLateDepartureTime;
        return $this;
    }
    /**
     * Get SchoolID value
     * @return string|null
     */
    public function getSchoolID()
    {
        return $this->SchoolID;
    }
    /**
     * Set SchoolID value
     * @param string $schoolID
     * @return \StructType\School
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        $this->SchoolID = $schoolID;
        return $this;
    }
    /**
     * Get AlternateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateID()
    {
        return isset($this->AlternateID) ? $this->AlternateID : null;
    }
    /**
     * Set AlternateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateID
     * @return \StructType\School
     */
    public function setAlternateID($alternateID = null)
    {
        // validation for constraint: string
        if (!is_null($alternateID) && !is_string($alternateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternateID)), __LINE__);
        }
        if (is_null($alternateID) || (is_array($alternateID) && empty($alternateID))) {
            unset($this->AlternateID);
        } else {
            $this->AlternateID = $alternateID;
        }
        return $this;
    }
    /**
     * Get TransportAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransportAddress()
    {
        return isset($this->TransportAddress) ? $this->TransportAddress : null;
    }
    /**
     * Set TransportAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transportAddress
     * @return \StructType\School
     */
    public function setTransportAddress($transportAddress = null)
    {
        // validation for constraint: string
        if (!is_null($transportAddress) && !is_string($transportAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportAddress)), __LINE__);
        }
        if (is_null($transportAddress) || (is_array($transportAddress) && empty($transportAddress))) {
            unset($this->TransportAddress);
        } else {
            $this->TransportAddress = $transportAddress;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\School
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address_v2|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address_v2 $address
     * @return \StructType\School
     */
    public function setAddress(\StructType\Address_v2 $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCapacity()
    {
        return isset($this->Capacity) ? $this->Capacity : null;
    }
    /**
     * Set Capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $capacity
     * @return \StructType\School
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !is_numeric($capacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capacity)), __LINE__);
        }
        if (is_null($capacity) || (is_array($capacity) && empty($capacity))) {
            unset($this->Capacity);
        } else {
            $this->Capacity = $capacity;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\School
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get GradeSchoolTypeGuid value
     * @return string|null
     */
    public function getGradeSchoolTypeGuid()
    {
        return $this->GradeSchoolTypeGuid;
    }
    /**
     * Set GradeSchoolTypeGuid value
     * @param string $gradeSchoolTypeGuid
     * @return \StructType\School
     */
    public function setGradeSchoolTypeGuid($gradeSchoolTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeSchoolTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeSchoolTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeSchoolTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeSchoolTypeGuid) && !is_string($gradeSchoolTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeSchoolTypeGuid)), __LINE__);
        }
        $this->GradeSchoolTypeGuid = $gradeSchoolTypeGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\School
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\School
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get Public value
     * @return bool|null
     */
    public function getPublic()
    {
        return $this->Public;
    }
    /**
     * Set Public value
     * @param bool $public
     * @return \StructType\School
     */
    public function setPublic($public = null)
    {
        // validation for constraint: boolean
        if (!is_null($public) && !is_bool($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($public)), __LINE__);
        }
        $this->Public = $public;
        return $this;
    }
    /**
     * Get Regular value
     * @return bool|null
     */
    public function getRegular()
    {
        return $this->Regular;
    }
    /**
     * Set Regular value
     * @param bool $regular
     * @return \StructType\School
     */
    public function setRegular($regular = null)
    {
        // validation for constraint: boolean
        if (!is_null($regular) && !is_bool($regular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($regular)), __LINE__);
        }
        $this->Regular = $regular;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\School
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SIFGuid value
     * @return string|null
     */
    public function getSIFGuid()
    {
        return $this->SIFGuid;
    }
    /**
     * Set SIFGuid value
     * @param string $sIFGuid
     * @return \StructType\School
     */
    public function setSIFGuid($sIFGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sIFGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($sIFGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sIFGuid) && !is_string($sIFGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sIFGuid)), __LINE__);
        }
        $this->SIFGuid = $sIFGuid;
        return $this;
    }
    /**
     * Get SchoolGuid value
     * @return string|null
     */
    public function getSchoolGuid()
    {
        return $this->SchoolGuid;
    }
    /**
     * Set SchoolGuid value
     * @param string $schoolGuid
     * @return \StructType\School
     */
    public function setSchoolGuid($schoolGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($schoolGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schoolGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($schoolGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($schoolGuid) && !is_string($schoolGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolGuid)), __LINE__);
        }
        $this->SchoolGuid = $schoolGuid;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\School
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GradeSchoolType|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GradeSchoolType $type
     * @return \StructType\School
     */
    public function setType(\StructType\GradeSchoolType $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get WebPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebPage()
    {
        return isset($this->WebPage) ? $this->WebPage : null;
    }
    /**
     * Set WebPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webPage
     * @return \StructType\School
     */
    public function setWebPage($webPage = null)
    {
        // validation for constraint: string
        if (!is_null($webPage) && !is_string($webPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webPage)), __LINE__);
        }
        if (is_null($webPage) || (is_array($webPage) && empty($webPage))) {
            unset($this->WebPage);
        } else {
            $this->WebPage = $webPage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\School
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
