<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteItinerary StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteItinerary
 * @subpackage Structs
 */
class RouteItinerary extends AbstractStructBase
{
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Frequency;
    /**
     * The RouteElements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRouteElement
     */
    public $RouteElements;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * Constructor method for RouteItinerary
     * @uses RouteItinerary::setFrequency()
     * @uses RouteItinerary::setRouteElements()
     * @uses RouteItinerary::setRouteID()
     * @param string $frequency
     * @param \ArrayType\ArrayOfRouteElement $routeElements
     * @param string $routeID
     */
    public function __construct($frequency = null, \ArrayType\ArrayOfRouteElement $routeElements = null, $routeID = null)
    {
        $this
            ->setFrequency($frequency)
            ->setRouteElements($routeElements)
            ->setRouteID($routeID);
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\RouteItinerary
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get RouteElements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRouteElement|null
     */
    public function getRouteElements()
    {
        return isset($this->RouteElements) ? $this->RouteElements : null;
    }
    /**
     * Set RouteElements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRouteElement $routeElements
     * @return \StructType\RouteItinerary
     */
    public function setRouteElements(\ArrayType\ArrayOfRouteElement $routeElements = null)
    {
        if (is_null($routeElements) || (is_array($routeElements) && empty($routeElements))) {
            unset($this->RouteElements);
        } else {
            $this->RouteElements = $routeElements;
        }
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\RouteItinerary
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RouteItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
