<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteElement StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteElement
 * @subpackage Structs
 */
class RouteElement extends AbstractStructBase
{
    /**
     * The DeadheadGuid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeadheadGuid;
    /**
     * The RunID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RunID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for RouteElement
     * @uses RouteElement::setDeadheadGuid()
     * @uses RouteElement::setRunID()
     * @uses RouteElement::setType()
     * @param string $deadheadGuid
     * @param string $runID
     * @param string $type
     */
    public function __construct($deadheadGuid = null, $runID = null, $type = null)
    {
        $this
            ->setDeadheadGuid($deadheadGuid)
            ->setRunID($runID)
            ->setType($type);
    }
    /**
     * Get DeadheadGuid value
     * @return string|null
     */
    public function getDeadheadGuid()
    {
        return $this->DeadheadGuid;
    }
    /**
     * Set DeadheadGuid value
     * @param string $deadheadGuid
     * @return \StructType\RouteElement
     */
    public function setDeadheadGuid($deadheadGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deadheadGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($deadheadGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deadheadGuid) && !is_string($deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deadheadGuid)), __LINE__);
        }
        $this->DeadheadGuid = $deadheadGuid;
        return $this;
    }
    /**
     * Get RunID value
     * @return string|null
     */
    public function getRunID()
    {
        return $this->RunID;
    }
    /**
     * Set RunID value
     * @param string $runID
     * @return \StructType\RouteElement
     */
    public function setRunID($runID = null)
    {
        // validation for constraint: string
        if (!is_null($runID) && !is_string($runID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runID)), __LINE__);
        }
        $this->RunID = $runID;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\RouteElement
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RouteElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
