<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Route StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Route
 * @subpackage Structs
 */
class Route extends AbstractStructBase
{
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ModifiedDate
     * @var string
     */
    public $ModifiedDate;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The VehicleGuid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleGuid;
    /**
     * The VehicleID
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $VehicleID;
    /**
     * The OperatorID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatorID;
    /**
     * Constructor method for Route
     * @uses Route::setCreatedDate()
     * @uses Route::setDescription()
     * @uses Route::setModifiedDate()
     * @uses Route::setRouteID()
     * @uses Route::setVehicleGuid()
     * @uses Route::setVehicleID()
     * @uses Route::setOperatorID()
     * @param string $createdDate
     * @param string $description
     * @param string $modifiedDate
     * @param string $routeID
     * @param string $vehicleGuid
     * @param string $vehicleID
     * @param string $operatorID
     */
    public function __construct($createdDate = null, $description = null, $modifiedDate = null, $routeID = null, $vehicleGuid = null, $vehicleID = null, $operatorID = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setModifiedDate($modifiedDate)
            ->setRouteID($routeID)
            ->setVehicleGuid($vehicleGuid)
            ->setVehicleID($vehicleID)
            ->setOperatorID($operatorID);
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Route
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Route
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\Route
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get RouteID value
     * @return string|null
     */
    public function getRouteID()
    {
        return $this->RouteID;
    }
    /**
     * Set RouteID value
     * @param string $routeID
     * @return \StructType\Route
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        $this->RouteID = $routeID;
        return $this;
    }
    /**
     * Get VehicleGuid value
     * @return string|null
     */
    public function getVehicleGuid()
    {
        return $this->VehicleGuid;
    }
    /**
     * Set VehicleGuid value
     * @param string $vehicleGuid
     * @return \StructType\Route
     */
    public function setVehicleGuid($vehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleGuid) && !is_string($vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleGuid)), __LINE__);
        }
        $this->VehicleGuid = $vehicleGuid;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return string|null
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param string $vehicleID
     * @return \StructType\Route
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Get OperatorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatorID()
    {
        return isset($this->OperatorID) ? $this->OperatorID : null;
    }
    /**
     * Set OperatorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatorID
     * @return \StructType\Route
     */
    public function setOperatorID($operatorID = null)
    {
        // validation for constraint: string
        if (!is_null($operatorID) && !is_string($operatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorID)), __LINE__);
        }
        if (is_null($operatorID) || (is_array($operatorID) && empty($operatorID))) {
            unset($this->OperatorID);
        } else {
            $this->OperatorID = $operatorID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Route
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
