<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Policy
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The DistanceToSchool
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DistanceToSchool;
    /**
     * The DistanceToStop
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DistanceToStop;
    /**
     * The GradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeGuid;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The PolicyGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PolicyGuid;
    /**
     * The Reguar
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Reguar;
    /**
     * The SpecialEd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SpecialEd;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Weight;
    /**
     * Constructor method for Policy
     * @uses Policy::setDistanceToSchool()
     * @uses Policy::setDistanceToStop()
     * @uses Policy::setGradeGuid()
     * @uses Policy::setID()
     * @uses Policy::setPolicyGuid()
     * @uses Policy::setReguar()
     * @uses Policy::setSpecialEd()
     * @uses Policy::setWeight()
     * @param float $distanceToSchool
     * @param float $distanceToStop
     * @param string $gradeGuid
     * @param \StructType\BPID $iD
     * @param string $policyGuid
     * @param bool $reguar
     * @param bool $specialEd
     * @param float $weight
     */
    public function __construct($distanceToSchool = null, $distanceToStop = null, $gradeGuid = null, \StructType\BPID $iD = null, $policyGuid = null, $reguar = null, $specialEd = null, $weight = null)
    {
        $this
            ->setDistanceToSchool($distanceToSchool)
            ->setDistanceToStop($distanceToStop)
            ->setGradeGuid($gradeGuid)
            ->setID($iD)
            ->setPolicyGuid($policyGuid)
            ->setReguar($reguar)
            ->setSpecialEd($specialEd)
            ->setWeight($weight);
    }
    /**
     * Get DistanceToSchool value
     * @return float|null
     */
    public function getDistanceToSchool()
    {
        return $this->DistanceToSchool;
    }
    /**
     * Set DistanceToSchool value
     * @param float $distanceToSchool
     * @return \StructType\Policy
     */
    public function setDistanceToSchool($distanceToSchool = null)
    {
        $this->DistanceToSchool = $distanceToSchool;
        return $this;
    }
    /**
     * Get DistanceToStop value
     * @return float|null
     */
    public function getDistanceToStop()
    {
        return $this->DistanceToStop;
    }
    /**
     * Set DistanceToStop value
     * @param float $distanceToStop
     * @return \StructType\Policy
     */
    public function setDistanceToStop($distanceToStop = null)
    {
        $this->DistanceToStop = $distanceToStop;
        return $this;
    }
    /**
     * Get GradeGuid value
     * @return string|null
     */
    public function getGradeGuid()
    {
        return $this->GradeGuid;
    }
    /**
     * Set GradeGuid value
     * @param string $gradeGuid
     * @return \StructType\Policy
     */
    public function setGradeGuid($gradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeGuid) && !is_string($gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeGuid)), __LINE__);
        }
        $this->GradeGuid = $gradeGuid;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\Policy
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get PolicyGuid value
     * @return string|null
     */
    public function getPolicyGuid()
    {
        return $this->PolicyGuid;
    }
    /**
     * Set PolicyGuid value
     * @param string $policyGuid
     * @return \StructType\Policy
     */
    public function setPolicyGuid($policyGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($policyGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $policyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($policyGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($policyGuid) && !is_string($policyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policyGuid)), __LINE__);
        }
        $this->PolicyGuid = $policyGuid;
        return $this;
    }
    /**
     * Get Reguar value
     * @return bool|null
     */
    public function getReguar()
    {
        return $this->Reguar;
    }
    /**
     * Set Reguar value
     * @param bool $reguar
     * @return \StructType\Policy
     */
    public function setReguar($reguar = null)
    {
        // validation for constraint: boolean
        if (!is_null($reguar) && !is_bool($reguar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reguar)), __LINE__);
        }
        $this->Reguar = $reguar;
        return $this;
    }
    /**
     * Get SpecialEd value
     * @return bool|null
     */
    public function getSpecialEd()
    {
        return $this->SpecialEd;
    }
    /**
     * Set SpecialEd value
     * @param bool $specialEd
     * @return \StructType\Policy
     */
    public function setSpecialEd($specialEd = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialEd) && !is_bool($specialEd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($specialEd)), __LINE__);
        }
        $this->SpecialEd = $specialEd;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\Policy
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Policy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
