<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Location
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BPID
     */
    public $ID;
    /**
     * The InRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $InRange;
    /**
     * The LatLong
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Position
     */
    public $LatLong;
    /**
     * The LocationGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LocationGuid;
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationID;
    /**
     * The LocationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LocationType
     */
    public $LocationType;
    /**
     * The LocationTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LocationTypeGuid;
    /**
     * The MatchMunicipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MatchMunicipality;
    /**
     * The MatchSchool
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MatchSchool;
    /**
     * The MatchStreet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MatchStreet;
    /**
     * The Municipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Municipality;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Position;
    /**
     * The PositionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PositionType
     */
    public $PositionType;
    /**
     * The PositionTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PositionTypeGuid;
    /**
     * The Protected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protected;
    /**
     * The RangeFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RangeFrom;
    /**
     * The RangeTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RangeTo;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The SchoolID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolID;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * The Use
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Use;
    /**
     * The ZoneGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ZoneGuid;
    /**
     * Constructor method for Location
     * @uses Location::setDescription()
     * @uses Location::setEffectiveDate()
     * @uses Location::setID()
     * @uses Location::setInRange()
     * @uses Location::setLatLong()
     * @uses Location::setLocationGuid()
     * @uses Location::setLocationID()
     * @uses Location::setLocationType()
     * @uses Location::setLocationTypeGuid()
     * @uses Location::setMatchMunicipality()
     * @uses Location::setMatchSchool()
     * @uses Location::setMatchStreet()
     * @uses Location::setMunicipality()
     * @uses Location::setPosition()
     * @uses Location::setPositionType()
     * @uses Location::setPositionTypeGuid()
     * @uses Location::setProtected()
     * @uses Location::setRangeFrom()
     * @uses Location::setRangeTo()
     * @uses Location::setRetireDate()
     * @uses Location::setSchoolID()
     * @uses Location::setStreetName()
     * @uses Location::setUse()
     * @uses Location::setZoneGuid()
     * @param string $description
     * @param string $effectiveDate
     * @param \StructType\BPID $iD
     * @param bool $inRange
     * @param \StructType\Position $latLong
     * @param string $locationGuid
     * @param string $locationID
     * @param \StructType\LocationType $locationType
     * @param string $locationTypeGuid
     * @param bool $matchMunicipality
     * @param bool $matchSchool
     * @param bool $matchStreet
     * @param string $municipality
     * @param string $position
     * @param \StructType\PositionType $positionType
     * @param string $positionTypeGuid
     * @param bool $protected
     * @param int $rangeFrom
     * @param int $rangeTo
     * @param string $retireDate
     * @param string $schoolID
     * @param string $streetName
     * @param bool $use
     * @param string $zoneGuid
     */
    public function __construct($description = null, $effectiveDate = null, \StructType\BPID $iD = null, $inRange = null, \StructType\Position $latLong = null, $locationGuid = null, $locationID = null, \StructType\LocationType $locationType = null, $locationTypeGuid = null, $matchMunicipality = null, $matchSchool = null, $matchStreet = null, $municipality = null, $position = null, \StructType\PositionType $positionType = null, $positionTypeGuid = null, $protected = null, $rangeFrom = null, $rangeTo = null, $retireDate = null, $schoolID = null, $streetName = null, $use = null, $zoneGuid = null)
    {
        $this
            ->setDescription($description)
            ->setEffectiveDate($effectiveDate)
            ->setID($iD)
            ->setInRange($inRange)
            ->setLatLong($latLong)
            ->setLocationGuid($locationGuid)
            ->setLocationID($locationID)
            ->setLocationType($locationType)
            ->setLocationTypeGuid($locationTypeGuid)
            ->setMatchMunicipality($matchMunicipality)
            ->setMatchSchool($matchSchool)
            ->setMatchStreet($matchStreet)
            ->setMunicipality($municipality)
            ->setPosition($position)
            ->setPositionType($positionType)
            ->setPositionTypeGuid($positionTypeGuid)
            ->setProtected($protected)
            ->setRangeFrom($rangeFrom)
            ->setRangeTo($rangeTo)
            ->setRetireDate($retireDate)
            ->setSchoolID($schoolID)
            ->setStreetName($streetName)
            ->setUse($use)
            ->setZoneGuid($zoneGuid);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Location
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Location
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BPID|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BPID $iD
     * @return \StructType\Location
     */
    public function setID(\StructType\BPID $iD = null)
    {
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get InRange value
     * @return bool|null
     */
    public function getInRange()
    {
        return $this->InRange;
    }
    /**
     * Set InRange value
     * @param bool $inRange
     * @return \StructType\Location
     */
    public function setInRange($inRange = null)
    {
        // validation for constraint: boolean
        if (!is_null($inRange) && !is_bool($inRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inRange)), __LINE__);
        }
        $this->InRange = $inRange;
        return $this;
    }
    /**
     * Get LatLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Position|null
     */
    public function getLatLong()
    {
        return isset($this->LatLong) ? $this->LatLong : null;
    }
    /**
     * Set LatLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Position $latLong
     * @return \StructType\Location
     */
    public function setLatLong(\StructType\Position $latLong = null)
    {
        if (is_null($latLong) || (is_array($latLong) && empty($latLong))) {
            unset($this->LatLong);
        } else {
            $this->LatLong = $latLong;
        }
        return $this;
    }
    /**
     * Get LocationGuid value
     * @return string|null
     */
    public function getLocationGuid()
    {
        return $this->LocationGuid;
    }
    /**
     * Set LocationGuid value
     * @param string $locationGuid
     * @return \StructType\Location
     */
    public function setLocationGuid($locationGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($locationGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $locationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($locationGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locationGuid) && !is_string($locationGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationGuid)), __LINE__);
        }
        $this->LocationGuid = $locationGuid;
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationID
     * @return \StructType\Location
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: string
        if (!is_null($locationID) && !is_string($locationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationID)), __LINE__);
        }
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LocationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LocationType|null
     */
    public function getLocationType()
    {
        return isset($this->LocationType) ? $this->LocationType : null;
    }
    /**
     * Set LocationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LocationType $locationType
     * @return \StructType\Location
     */
    public function setLocationType(\StructType\LocationType $locationType = null)
    {
        if (is_null($locationType) || (is_array($locationType) && empty($locationType))) {
            unset($this->LocationType);
        } else {
            $this->LocationType = $locationType;
        }
        return $this;
    }
    /**
     * Get LocationTypeGuid value
     * @return string|null
     */
    public function getLocationTypeGuid()
    {
        return $this->LocationTypeGuid;
    }
    /**
     * Set LocationTypeGuid value
     * @param string $locationTypeGuid
     * @return \StructType\Location
     */
    public function setLocationTypeGuid($locationTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($locationTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $locationTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($locationTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locationTypeGuid) && !is_string($locationTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationTypeGuid)), __LINE__);
        }
        $this->LocationTypeGuid = $locationTypeGuid;
        return $this;
    }
    /**
     * Get MatchMunicipality value
     * @return bool|null
     */
    public function getMatchMunicipality()
    {
        return $this->MatchMunicipality;
    }
    /**
     * Set MatchMunicipality value
     * @param bool $matchMunicipality
     * @return \StructType\Location
     */
    public function setMatchMunicipality($matchMunicipality = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchMunicipality) && !is_bool($matchMunicipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($matchMunicipality)), __LINE__);
        }
        $this->MatchMunicipality = $matchMunicipality;
        return $this;
    }
    /**
     * Get MatchSchool value
     * @return bool|null
     */
    public function getMatchSchool()
    {
        return $this->MatchSchool;
    }
    /**
     * Set MatchSchool value
     * @param bool $matchSchool
     * @return \StructType\Location
     */
    public function setMatchSchool($matchSchool = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchSchool) && !is_bool($matchSchool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($matchSchool)), __LINE__);
        }
        $this->MatchSchool = $matchSchool;
        return $this;
    }
    /**
     * Get MatchStreet value
     * @return bool|null
     */
    public function getMatchStreet()
    {
        return $this->MatchStreet;
    }
    /**
     * Set MatchStreet value
     * @param bool $matchStreet
     * @return \StructType\Location
     */
    public function setMatchStreet($matchStreet = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchStreet) && !is_bool($matchStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($matchStreet)), __LINE__);
        }
        $this->MatchStreet = $matchStreet;
        return $this;
    }
    /**
     * Get Municipality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipality()
    {
        return isset($this->Municipality) ? $this->Municipality : null;
    }
    /**
     * Set Municipality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipality
     * @return \StructType\Location
     */
    public function setMunicipality($municipality = null)
    {
        // validation for constraint: string
        if (!is_null($municipality) && !is_string($municipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipality)), __LINE__);
        }
        if (is_null($municipality) || (is_array($municipality) && empty($municipality))) {
            unset($this->Municipality);
        } else {
            $this->Municipality = $municipality;
        }
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $position
     * @return \StructType\Location
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
    /**
     * Get PositionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PositionType|null
     */
    public function getPositionType()
    {
        return isset($this->PositionType) ? $this->PositionType : null;
    }
    /**
     * Set PositionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PositionType $positionType
     * @return \StructType\Location
     */
    public function setPositionType(\StructType\PositionType $positionType = null)
    {
        if (is_null($positionType) || (is_array($positionType) && empty($positionType))) {
            unset($this->PositionType);
        } else {
            $this->PositionType = $positionType;
        }
        return $this;
    }
    /**
     * Get PositionTypeGuid value
     * @return string|null
     */
    public function getPositionTypeGuid()
    {
        return $this->PositionTypeGuid;
    }
    /**
     * Set PositionTypeGuid value
     * @param string $positionTypeGuid
     * @return \StructType\Location
     */
    public function setPositionTypeGuid($positionTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($positionTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $positionTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($positionTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($positionTypeGuid) && !is_string($positionTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($positionTypeGuid)), __LINE__);
        }
        $this->PositionTypeGuid = $positionTypeGuid;
        return $this;
    }
    /**
     * Get Protected value
     * @return bool|null
     */
    public function getProtected()
    {
        return $this->Protected;
    }
    /**
     * Set Protected value
     * @param bool $protected
     * @return \StructType\Location
     */
    public function setProtected($protected = null)
    {
        // validation for constraint: boolean
        if (!is_null($protected) && !is_bool($protected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protected)), __LINE__);
        }
        $this->Protected = $protected;
        return $this;
    }
    /**
     * Get RangeFrom value
     * @return int|null
     */
    public function getRangeFrom()
    {
        return $this->RangeFrom;
    }
    /**
     * Set RangeFrom value
     * @param int $rangeFrom
     * @return \StructType\Location
     */
    public function setRangeFrom($rangeFrom = null)
    {
        // validation for constraint: int
        if (!is_null($rangeFrom) && !is_numeric($rangeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rangeFrom)), __LINE__);
        }
        $this->RangeFrom = $rangeFrom;
        return $this;
    }
    /**
     * Get RangeTo value
     * @return int|null
     */
    public function getRangeTo()
    {
        return $this->RangeTo;
    }
    /**
     * Set RangeTo value
     * @param int $rangeTo
     * @return \StructType\Location
     */
    public function setRangeTo($rangeTo = null)
    {
        // validation for constraint: int
        if (!is_null($rangeTo) && !is_numeric($rangeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rangeTo)), __LINE__);
        }
        $this->RangeTo = $rangeTo;
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\Location
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get SchoolID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolID()
    {
        return isset($this->SchoolID) ? $this->SchoolID : null;
    }
    /**
     * Set SchoolID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolID
     * @return \StructType\Location
     */
    public function setSchoolID($schoolID = null)
    {
        // validation for constraint: string
        if (!is_null($schoolID) && !is_string($schoolID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolID)), __LINE__);
        }
        if (is_null($schoolID) || (is_array($schoolID) && empty($schoolID))) {
            unset($this->SchoolID);
        } else {
            $this->SchoolID = $schoolID;
        }
        return $this;
    }
    /**
     * Get StreetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetName()
    {
        return isset($this->StreetName) ? $this->StreetName : null;
    }
    /**
     * Set StreetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetName
     * @return \StructType\Location
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        if (is_null($streetName) || (is_array($streetName) && empty($streetName))) {
            unset($this->StreetName);
        } else {
            $this->StreetName = $streetName;
        }
        return $this;
    }
    /**
     * Get Use value
     * @return bool|null
     */
    public function getUse()
    {
        return $this->Use;
    }
    /**
     * Set Use value
     * @param bool $use
     * @return \StructType\Location
     */
    public function setUse($use = null)
    {
        // validation for constraint: boolean
        if (!is_null($use) && !is_bool($use)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($use)), __LINE__);
        }
        $this->Use = $use;
        return $this;
    }
    /**
     * Get ZoneGuid value
     * @return string|null
     */
    public function getZoneGuid()
    {
        return $this->ZoneGuid;
    }
    /**
     * Set ZoneGuid value
     * @param string $zoneGuid
     * @return \StructType\Location
     */
    public function setZoneGuid($zoneGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($zoneGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $zoneGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($zoneGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zoneGuid) && !is_string($zoneGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zoneGuid)), __LINE__);
        }
        $this->ZoneGuid = $zoneGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
