<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStudentsWithTransChanges StructType
 * @subpackage Structs
 */
class GetStudentsWithTransChanges extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The sinceDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sinceDateTime;
    /**
     * The toDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toDate;
    /**
     * The includeDriverAndVehicleChanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeDriverAndVehicleChanges;
    /**
     * Constructor method for GetStudentsWithTransChanges
     * @uses GetStudentsWithTransChanges::setDatabaseGuid()
     * @uses GetStudentsWithTransChanges::setSinceDateTime()
     * @uses GetStudentsWithTransChanges::setToDate()
     * @uses GetStudentsWithTransChanges::setIncludeDriverAndVehicleChanges()
     * @param string $databaseGuid
     * @param string $sinceDateTime
     * @param string $toDate
     * @param bool $includeDriverAndVehicleChanges
     */
    public function __construct($databaseGuid = null, $sinceDateTime = null, $toDate = null, $includeDriverAndVehicleChanges = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setSinceDateTime($sinceDateTime)
            ->setToDate($toDate)
            ->setIncludeDriverAndVehicleChanges($includeDriverAndVehicleChanges);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetStudentsWithTransChanges
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get sinceDateTime value
     * @return string|null
     */
    public function getSinceDateTime()
    {
        return $this->sinceDateTime;
    }
    /**
     * Set sinceDateTime value
     * @param string $sinceDateTime
     * @return \StructType\GetStudentsWithTransChanges
     */
    public function setSinceDateTime($sinceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sinceDateTime) && !is_string($sinceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sinceDateTime)), __LINE__);
        }
        $this->sinceDateTime = $sinceDateTime;
        return $this;
    }
    /**
     * Get toDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }
    /**
     * Set toDate value
     * @param string $toDate
     * @return \StructType\GetStudentsWithTransChanges
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->toDate = $toDate;
        return $this;
    }
    /**
     * Get includeDriverAndVehicleChanges value
     * @return bool|null
     */
    public function getIncludeDriverAndVehicleChanges()
    {
        return $this->includeDriverAndVehicleChanges;
    }
    /**
     * Set includeDriverAndVehicleChanges value
     * @param bool $includeDriverAndVehicleChanges
     * @return \StructType\GetStudentsWithTransChanges
     */
    public function setIncludeDriverAndVehicleChanges($includeDriverAndVehicleChanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDriverAndVehicleChanges) && !is_bool($includeDriverAndVehicleChanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeDriverAndVehicleChanges)), __LINE__);
        }
        $this->includeDriverAndVehicleChanges = $includeDriverAndVehicleChanges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStudentsWithTransChanges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
