<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStudentsWhoHaveTravelCodeChanges StructType
 * @subpackage Structs
 */
class GetStudentsWhoHaveTravelCodeChanges extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The fromDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromDateTime;
    /**
     * The toDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toDateTime;
    /**
     * Constructor method for GetStudentsWhoHaveTravelCodeChanges
     * @uses GetStudentsWhoHaveTravelCodeChanges::setDatabaseGuid()
     * @uses GetStudentsWhoHaveTravelCodeChanges::setFromDateTime()
     * @uses GetStudentsWhoHaveTravelCodeChanges::setToDateTime()
     * @param string $databaseGuid
     * @param string $fromDateTime
     * @param string $toDateTime
     */
    public function __construct($databaseGuid = null, $fromDateTime = null, $toDateTime = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setFromDateTime($fromDateTime)
            ->setToDateTime($toDateTime);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetStudentsWhoHaveTravelCodeChanges
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get fromDateTime value
     * @return string|null
     */
    public function getFromDateTime()
    {
        return $this->fromDateTime;
    }
    /**
     * Set fromDateTime value
     * @param string $fromDateTime
     * @return \StructType\GetStudentsWhoHaveTravelCodeChanges
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDateTime)), __LINE__);
        }
        $this->fromDateTime = $fromDateTime;
        return $this;
    }
    /**
     * Get toDateTime value
     * @return string|null
     */
    public function getToDateTime()
    {
        return $this->toDateTime;
    }
    /**
     * Set toDateTime value
     * @param string $toDateTime
     * @return \StructType\GetStudentsWhoHaveTravelCodeChanges
     */
    public function setToDateTime($toDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toDateTime) && !is_string($toDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDateTime)), __LINE__);
        }
        $this->toDateTime = $toDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStudentsWhoHaveTravelCodeChanges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
