<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStudentsComplete StructType
 * @subpackage Structs
 */
class GetStudentsComplete extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The studentIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $studentIds;
    /**
     * The byAlternateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $byAlternateId;
    /**
     * The includeContacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeContacts;
    /**
     * The includeEnrollments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeEnrollments;
    /**
     * The includeTransporationDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeTransporationDetails;
    /**
     * Constructor method for GetStudentsComplete
     * @uses GetStudentsComplete::setDatabaseGuid()
     * @uses GetStudentsComplete::setStudentIds()
     * @uses GetStudentsComplete::setByAlternateId()
     * @uses GetStudentsComplete::setIncludeContacts()
     * @uses GetStudentsComplete::setIncludeEnrollments()
     * @uses GetStudentsComplete::setIncludeTransporationDetails()
     * @param string $databaseGuid
     * @param \ArrayType\ArrayOfstring $studentIds
     * @param bool $byAlternateId
     * @param bool $includeContacts
     * @param bool $includeEnrollments
     * @param bool $includeTransporationDetails
     */
    public function __construct($databaseGuid = null, \ArrayType\ArrayOfstring $studentIds = null, $byAlternateId = null, $includeContacts = null, $includeEnrollments = null, $includeTransporationDetails = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setStudentIds($studentIds)
            ->setByAlternateId($byAlternateId)
            ->setIncludeContacts($includeContacts)
            ->setIncludeEnrollments($includeEnrollments)
            ->setIncludeTransporationDetails($includeTransporationDetails);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetStudentsComplete
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get studentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getStudentIds()
    {
        return isset($this->studentIds) ? $this->studentIds : null;
    }
    /**
     * Set studentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $studentIds
     * @return \StructType\GetStudentsComplete
     */
    public function setStudentIds(\ArrayType\ArrayOfstring $studentIds = null)
    {
        if (is_null($studentIds) || (is_array($studentIds) && empty($studentIds))) {
            unset($this->studentIds);
        } else {
            $this->studentIds = $studentIds;
        }
        return $this;
    }
    /**
     * Get byAlternateId value
     * @return bool|null
     */
    public function getByAlternateId()
    {
        return $this->byAlternateId;
    }
    /**
     * Set byAlternateId value
     * @param bool $byAlternateId
     * @return \StructType\GetStudentsComplete
     */
    public function setByAlternateId($byAlternateId = null)
    {
        // validation for constraint: boolean
        if (!is_null($byAlternateId) && !is_bool($byAlternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($byAlternateId)), __LINE__);
        }
        $this->byAlternateId = $byAlternateId;
        return $this;
    }
    /**
     * Get includeContacts value
     * @return bool|null
     */
    public function getIncludeContacts()
    {
        return $this->includeContacts;
    }
    /**
     * Set includeContacts value
     * @param bool $includeContacts
     * @return \StructType\GetStudentsComplete
     */
    public function setIncludeContacts($includeContacts = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContacts) && !is_bool($includeContacts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeContacts)), __LINE__);
        }
        $this->includeContacts = $includeContacts;
        return $this;
    }
    /**
     * Get includeEnrollments value
     * @return bool|null
     */
    public function getIncludeEnrollments()
    {
        return $this->includeEnrollments;
    }
    /**
     * Set includeEnrollments value
     * @param bool $includeEnrollments
     * @return \StructType\GetStudentsComplete
     */
    public function setIncludeEnrollments($includeEnrollments = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEnrollments) && !is_bool($includeEnrollments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeEnrollments)), __LINE__);
        }
        $this->includeEnrollments = $includeEnrollments;
        return $this;
    }
    /**
     * Get includeTransporationDetails value
     * @return bool|null
     */
    public function getIncludeTransporationDetails()
    {
        return $this->includeTransporationDetails;
    }
    /**
     * Set includeTransporationDetails value
     * @param bool $includeTransporationDetails
     * @return \StructType\GetStudentsComplete
     */
    public function setIncludeTransporationDetails($includeTransporationDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTransporationDetails) && !is_bool($includeTransporationDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTransporationDetails)), __LINE__);
        }
        $this->includeTransporationDetails = $includeTransporationDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStudentsComplete
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
