<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStudentStandard StructType
 * @subpackage Structs
 */
class GetStudentStandard extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The studentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $studentId;
    /**
     * The byAlternateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $byAlternateId;
    /**
     * Constructor method for GetStudentStandard
     * @uses GetStudentStandard::setDatabaseGuid()
     * @uses GetStudentStandard::setStudentId()
     * @uses GetStudentStandard::setByAlternateId()
     * @param string $databaseGuid
     * @param string $studentId
     * @param bool $byAlternateId
     */
    public function __construct($databaseGuid = null, $studentId = null, $byAlternateId = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setStudentId($studentId)
            ->setByAlternateId($byAlternateId);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetStudentStandard
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get studentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStudentId()
    {
        return isset($this->studentId) ? $this->studentId : null;
    }
    /**
     * Set studentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $studentId
     * @return \StructType\GetStudentStandard
     */
    public function setStudentId($studentId = null)
    {
        // validation for constraint: string
        if (!is_null($studentId) && !is_string($studentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentId)), __LINE__);
        }
        if (is_null($studentId) || (is_array($studentId) && empty($studentId))) {
            unset($this->studentId);
        } else {
            $this->studentId = $studentId;
        }
        return $this;
    }
    /**
     * Get byAlternateId value
     * @return bool|null
     */
    public function getByAlternateId()
    {
        return $this->byAlternateId;
    }
    /**
     * Set byAlternateId value
     * @param bool $byAlternateId
     * @return \StructType\GetStudentStandard
     */
    public function setByAlternateId($byAlternateId = null)
    {
        // validation for constraint: boolean
        if (!is_null($byAlternateId) && !is_bool($byAlternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($byAlternateId)), __LINE__);
        }
        $this->byAlternateId = $byAlternateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStudentStandard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
