<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStreetList StructType
 * @subpackage Structs
 */
class GetStreetList extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The packageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageSize;
    /**
     * The lastStreetNameGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $lastStreetNameGuid;
    /**
     * The streetFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $streetFilter;
    /**
     * The municipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $municipality;
    /**
     * Constructor method for GetStreetList
     * @uses GetStreetList::setDatabaseGuid()
     * @uses GetStreetList::setPackageSize()
     * @uses GetStreetList::setLastStreetNameGuid()
     * @uses GetStreetList::setStreetFilter()
     * @uses GetStreetList::setMunicipality()
     * @param string $databaseGuid
     * @param int $packageSize
     * @param string $lastStreetNameGuid
     * @param string $streetFilter
     * @param string $municipality
     */
    public function __construct($databaseGuid = null, $packageSize = null, $lastStreetNameGuid = null, $streetFilter = null, $municipality = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setPackageSize($packageSize)
            ->setLastStreetNameGuid($lastStreetNameGuid)
            ->setStreetFilter($streetFilter)
            ->setMunicipality($municipality);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetStreetList
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get packageSize value
     * @return int|null
     */
    public function getPackageSize()
    {
        return $this->packageSize;
    }
    /**
     * Set packageSize value
     * @param int $packageSize
     * @return \StructType\GetStreetList
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        $this->packageSize = $packageSize;
        return $this;
    }
    /**
     * Get lastStreetNameGuid value
     * @return string|null
     */
    public function getLastStreetNameGuid()
    {
        return $this->lastStreetNameGuid;
    }
    /**
     * Set lastStreetNameGuid value
     * @param string $lastStreetNameGuid
     * @return \StructType\GetStreetList
     */
    public function setLastStreetNameGuid($lastStreetNameGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastStreetNameGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastStreetNameGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastStreetNameGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastStreetNameGuid) && !is_string($lastStreetNameGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastStreetNameGuid)), __LINE__);
        }
        $this->lastStreetNameGuid = $lastStreetNameGuid;
        return $this;
    }
    /**
     * Get streetFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetFilter()
    {
        return isset($this->streetFilter) ? $this->streetFilter : null;
    }
    /**
     * Set streetFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetFilter
     * @return \StructType\GetStreetList
     */
    public function setStreetFilter($streetFilter = null)
    {
        // validation for constraint: string
        if (!is_null($streetFilter) && !is_string($streetFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetFilter)), __LINE__);
        }
        if (is_null($streetFilter) || (is_array($streetFilter) && empty($streetFilter))) {
            unset($this->streetFilter);
        } else {
            $this->streetFilter = $streetFilter;
        }
        return $this;
    }
    /**
     * Get municipality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipality()
    {
        return isset($this->municipality) ? $this->municipality : null;
    }
    /**
     * Set municipality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipality
     * @return \StructType\GetStreetList
     */
    public function setMunicipality($municipality = null)
    {
        // validation for constraint: string
        if (!is_null($municipality) && !is_string($municipality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipality)), __LINE__);
        }
        if (is_null($municipality) || (is_array($municipality) && empty($municipality))) {
            unset($this->municipality);
        } else {
            $this->municipality = $municipality;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStreetList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
