<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetIncidentCountForOperator StructType
 * @subpackage Structs
 */
class GetIncidentCountForOperator extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The operatorName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $operatorName;
    /**
     * The from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $from;
    /**
     * The upToButNotIncluding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $upToButNotIncluding;
    /**
     * Constructor method for GetIncidentCountForOperator
     * @uses GetIncidentCountForOperator::setDatabaseGuid()
     * @uses GetIncidentCountForOperator::setOperatorName()
     * @uses GetIncidentCountForOperator::setFrom()
     * @uses GetIncidentCountForOperator::setUpToButNotIncluding()
     * @param string $databaseGuid
     * @param string $operatorName
     * @param string $from
     * @param string $upToButNotIncluding
     */
    public function __construct($databaseGuid = null, $operatorName = null, $from = null, $upToButNotIncluding = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setOperatorName($operatorName)
            ->setFrom($from)
            ->setUpToButNotIncluding($upToButNotIncluding);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetIncidentCountForOperator
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get operatorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatorName()
    {
        return isset($this->operatorName) ? $this->operatorName : null;
    }
    /**
     * Set operatorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatorName
     * @return \StructType\GetIncidentCountForOperator
     */
    public function setOperatorName($operatorName = null)
    {
        // validation for constraint: string
        if (!is_null($operatorName) && !is_string($operatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorName)), __LINE__);
        }
        if (is_null($operatorName) || (is_array($operatorName) && empty($operatorName))) {
            unset($this->operatorName);
        } else {
            $this->operatorName = $operatorName;
        }
        return $this;
    }
    /**
     * Get from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom()
    {
        return isset($this->from) ? $this->from : null;
    }
    /**
     * Set from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from
     * @return \StructType\GetIncidentCountForOperator
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->from);
        } else {
            $this->from = $from;
        }
        return $this;
    }
    /**
     * Get upToButNotIncluding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpToButNotIncluding()
    {
        return isset($this->upToButNotIncluding) ? $this->upToButNotIncluding : null;
    }
    /**
     * Set upToButNotIncluding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $upToButNotIncluding
     * @return \StructType\GetIncidentCountForOperator
     */
    public function setUpToButNotIncluding($upToButNotIncluding = null)
    {
        // validation for constraint: string
        if (!is_null($upToButNotIncluding) && !is_string($upToButNotIncluding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($upToButNotIncluding)), __LINE__);
        }
        if (is_null($upToButNotIncluding) || (is_array($upToButNotIncluding) && empty($upToButNotIncluding))) {
            unset($this->upToButNotIncluding);
        } else {
            $this->upToButNotIncluding = $upToButNotIncluding;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetIncidentCountForOperator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
