<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContacts StructType
 * @subpackage Structs
 */
class GetContacts extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The studentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $studentID;
    /**
     * The searchByAlternateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $searchByAlternateId;
    /**
     * Constructor method for GetContacts
     * @uses GetContacts::setDatabaseGuid()
     * @uses GetContacts::setStudentID()
     * @uses GetContacts::setSearchByAlternateId()
     * @param string $databaseGuid
     * @param string $studentID
     * @param bool $searchByAlternateId
     */
    public function __construct($databaseGuid = null, $studentID = null, $searchByAlternateId = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setStudentID($studentID)
            ->setSearchByAlternateId($searchByAlternateId);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetContacts
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get studentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStudentID()
    {
        return isset($this->studentID) ? $this->studentID : null;
    }
    /**
     * Set studentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $studentID
     * @return \StructType\GetContacts
     */
    public function setStudentID($studentID = null)
    {
        // validation for constraint: string
        if (!is_null($studentID) && !is_string($studentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentID)), __LINE__);
        }
        if (is_null($studentID) || (is_array($studentID) && empty($studentID))) {
            unset($this->studentID);
        } else {
            $this->studentID = $studentID;
        }
        return $this;
    }
    /**
     * Get searchByAlternateId value
     * @return bool|null
     */
    public function getSearchByAlternateId()
    {
        return $this->searchByAlternateId;
    }
    /**
     * Set searchByAlternateId value
     * @param bool $searchByAlternateId
     * @return \StructType\GetContacts
     */
    public function setSearchByAlternateId($searchByAlternateId = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchByAlternateId) && !is_bool($searchByAlternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($searchByAlternateId)), __LINE__);
        }
        $this->searchByAlternateId = $searchByAlternateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetContacts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
