<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllStudentStopAssignments StructType
 * @subpackage Structs
 */
class GetAllStudentStopAssignments extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The packageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageSize;
    /**
     * The lastStudentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lastStudentID;
    /**
     * Constructor method for GetAllStudentStopAssignments
     * @uses GetAllStudentStopAssignments::setDatabaseGuid()
     * @uses GetAllStudentStopAssignments::setPackageSize()
     * @uses GetAllStudentStopAssignments::setLastStudentID()
     * @param string $databaseGuid
     * @param int $packageSize
     * @param string $lastStudentID
     */
    public function __construct($databaseGuid = null, $packageSize = null, $lastStudentID = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setPackageSize($packageSize)
            ->setLastStudentID($lastStudentID);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetAllStudentStopAssignments
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get packageSize value
     * @return int|null
     */
    public function getPackageSize()
    {
        return $this->packageSize;
    }
    /**
     * Set packageSize value
     * @param int $packageSize
     * @return \StructType\GetAllStudentStopAssignments
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        $this->packageSize = $packageSize;
        return $this;
    }
    /**
     * Get lastStudentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastStudentID()
    {
        return isset($this->lastStudentID) ? $this->lastStudentID : null;
    }
    /**
     * Set lastStudentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastStudentID
     * @return \StructType\GetAllStudentStopAssignments
     */
    public function setLastStudentID($lastStudentID = null)
    {
        // validation for constraint: string
        if (!is_null($lastStudentID) && !is_string($lastStudentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastStudentID)), __LINE__);
        }
        if (is_null($lastStudentID) || (is_array($lastStudentID) && empty($lastStudentID))) {
            unset($this->lastStudentID);
        } else {
            $this->lastStudentID = $lastStudentID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllStudentStopAssignments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
