<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllStudentComplete StructType
 * @subpackage Structs
 */
class GetAllStudentComplete extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The packageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageSize;
    /**
     * The studentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $studentId;
    /**
     * The schoolId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $schoolId;
    /**
     * The grade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $grade;
    /**
     * The byAlternateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $byAlternateId;
    /**
     * The onlyTransportedStudents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onlyTransportedStudents;
    /**
     * The includeContacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeContacts;
    /**
     * The includeEnrollments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeEnrollments;
    /**
     * The includeTransportationDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeTransportationDetails;
    /**
     * Constructor method for GetAllStudentComplete
     * @uses GetAllStudentComplete::setDatabaseGuid()
     * @uses GetAllStudentComplete::setPackageSize()
     * @uses GetAllStudentComplete::setStudentId()
     * @uses GetAllStudentComplete::setSchoolId()
     * @uses GetAllStudentComplete::setGrade()
     * @uses GetAllStudentComplete::setByAlternateId()
     * @uses GetAllStudentComplete::setOnlyTransportedStudents()
     * @uses GetAllStudentComplete::setIncludeContacts()
     * @uses GetAllStudentComplete::setIncludeEnrollments()
     * @uses GetAllStudentComplete::setIncludeTransportationDetails()
     * @param string $databaseGuid
     * @param int $packageSize
     * @param string $studentId
     * @param string $schoolId
     * @param string $grade
     * @param bool $byAlternateId
     * @param bool $onlyTransportedStudents
     * @param bool $includeContacts
     * @param bool $includeEnrollments
     * @param bool $includeTransportationDetails
     */
    public function __construct($databaseGuid = null, $packageSize = null, $studentId = null, $schoolId = null, $grade = null, $byAlternateId = null, $onlyTransportedStudents = null, $includeContacts = null, $includeEnrollments = null, $includeTransportationDetails = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setPackageSize($packageSize)
            ->setStudentId($studentId)
            ->setSchoolId($schoolId)
            ->setGrade($grade)
            ->setByAlternateId($byAlternateId)
            ->setOnlyTransportedStudents($onlyTransportedStudents)
            ->setIncludeContacts($includeContacts)
            ->setIncludeEnrollments($includeEnrollments)
            ->setIncludeTransportationDetails($includeTransportationDetails);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetAllStudentComplete
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get packageSize value
     * @return int|null
     */
    public function getPackageSize()
    {
        return $this->packageSize;
    }
    /**
     * Set packageSize value
     * @param int $packageSize
     * @return \StructType\GetAllStudentComplete
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        $this->packageSize = $packageSize;
        return $this;
    }
    /**
     * Get studentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStudentId()
    {
        return isset($this->studentId) ? $this->studentId : null;
    }
    /**
     * Set studentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $studentId
     * @return \StructType\GetAllStudentComplete
     */
    public function setStudentId($studentId = null)
    {
        // validation for constraint: string
        if (!is_null($studentId) && !is_string($studentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentId)), __LINE__);
        }
        if (is_null($studentId) || (is_array($studentId) && empty($studentId))) {
            unset($this->studentId);
        } else {
            $this->studentId = $studentId;
        }
        return $this;
    }
    /**
     * Get schoolId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolId()
    {
        return isset($this->schoolId) ? $this->schoolId : null;
    }
    /**
     * Set schoolId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolId
     * @return \StructType\GetAllStudentComplete
     */
    public function setSchoolId($schoolId = null)
    {
        // validation for constraint: string
        if (!is_null($schoolId) && !is_string($schoolId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolId)), __LINE__);
        }
        if (is_null($schoolId) || (is_array($schoolId) && empty($schoolId))) {
            unset($this->schoolId);
        } else {
            $this->schoolId = $schoolId;
        }
        return $this;
    }
    /**
     * Get grade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrade()
    {
        return isset($this->grade) ? $this->grade : null;
    }
    /**
     * Set grade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grade
     * @return \StructType\GetAllStudentComplete
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        if (is_null($grade) || (is_array($grade) && empty($grade))) {
            unset($this->grade);
        } else {
            $this->grade = $grade;
        }
        return $this;
    }
    /**
     * Get byAlternateId value
     * @return bool|null
     */
    public function getByAlternateId()
    {
        return $this->byAlternateId;
    }
    /**
     * Set byAlternateId value
     * @param bool $byAlternateId
     * @return \StructType\GetAllStudentComplete
     */
    public function setByAlternateId($byAlternateId = null)
    {
        // validation for constraint: boolean
        if (!is_null($byAlternateId) && !is_bool($byAlternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($byAlternateId)), __LINE__);
        }
        $this->byAlternateId = $byAlternateId;
        return $this;
    }
    /**
     * Get onlyTransportedStudents value
     * @return bool|null
     */
    public function getOnlyTransportedStudents()
    {
        return $this->onlyTransportedStudents;
    }
    /**
     * Set onlyTransportedStudents value
     * @param bool $onlyTransportedStudents
     * @return \StructType\GetAllStudentComplete
     */
    public function setOnlyTransportedStudents($onlyTransportedStudents = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyTransportedStudents) && !is_bool($onlyTransportedStudents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlyTransportedStudents)), __LINE__);
        }
        $this->onlyTransportedStudents = $onlyTransportedStudents;
        return $this;
    }
    /**
     * Get includeContacts value
     * @return bool|null
     */
    public function getIncludeContacts()
    {
        return $this->includeContacts;
    }
    /**
     * Set includeContacts value
     * @param bool $includeContacts
     * @return \StructType\GetAllStudentComplete
     */
    public function setIncludeContacts($includeContacts = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContacts) && !is_bool($includeContacts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeContacts)), __LINE__);
        }
        $this->includeContacts = $includeContacts;
        return $this;
    }
    /**
     * Get includeEnrollments value
     * @return bool|null
     */
    public function getIncludeEnrollments()
    {
        return $this->includeEnrollments;
    }
    /**
     * Set includeEnrollments value
     * @param bool $includeEnrollments
     * @return \StructType\GetAllStudentComplete
     */
    public function setIncludeEnrollments($includeEnrollments = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEnrollments) && !is_bool($includeEnrollments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeEnrollments)), __LINE__);
        }
        $this->includeEnrollments = $includeEnrollments;
        return $this;
    }
    /**
     * Get includeTransportationDetails value
     * @return bool|null
     */
    public function getIncludeTransportationDetails()
    {
        return $this->includeTransportationDetails;
    }
    /**
     * Set includeTransportationDetails value
     * @param bool $includeTransportationDetails
     * @return \StructType\GetAllStudentComplete
     */
    public function setIncludeTransportationDetails($includeTransportationDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTransportationDetails) && !is_bool($includeTransportationDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTransportationDetails)), __LINE__);
        }
        $this->includeTransportationDetails = $includeTransportationDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllStudentComplete
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
