<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllSchoolGrades.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllSchoolGrades.Options
 * @subpackage Structs
 */
class GetAllSchoolGrades_Options extends WebServiceRequestOptions
{
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Grade;
    /**
     * The LastSchoolGradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastSchoolGradeGuid;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * The SchoolId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolId;
    /**
     * Constructor method for GetAllSchoolGrades.Options
     * @uses GetAllSchoolGrades_Options::setGrade()
     * @uses GetAllSchoolGrades_Options::setLastSchoolGradeGuid()
     * @uses GetAllSchoolGrades_Options::setPackageSize()
     * @uses GetAllSchoolGrades_Options::setSchoolId()
     * @param string $grade
     * @param string $lastSchoolGradeGuid
     * @param int $packageSize
     * @param string $schoolId
     */
    public function __construct($grade = null, $lastSchoolGradeGuid = null, $packageSize = null, $schoolId = null)
    {
        $this
            ->setGrade($grade)
            ->setLastSchoolGradeGuid($lastSchoolGradeGuid)
            ->setPackageSize($packageSize)
            ->setSchoolId($schoolId);
    }
    /**
     * Get Grade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrade()
    {
        return isset($this->Grade) ? $this->Grade : null;
    }
    /**
     * Set Grade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grade
     * @return \StructType\GetAllSchoolGrades_Options
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        if (is_null($grade) || (is_array($grade) && empty($grade))) {
            unset($this->Grade);
        } else {
            $this->Grade = $grade;
        }
        return $this;
    }
    /**
     * Get LastSchoolGradeGuid value
     * @return string|null
     */
    public function getLastSchoolGradeGuid()
    {
        return $this->LastSchoolGradeGuid;
    }
    /**
     * Set LastSchoolGradeGuid value
     * @param string $lastSchoolGradeGuid
     * @return \StructType\GetAllSchoolGrades_Options
     */
    public function setLastSchoolGradeGuid($lastSchoolGradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastSchoolGradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastSchoolGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastSchoolGradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastSchoolGradeGuid) && !is_string($lastSchoolGradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastSchoolGradeGuid)), __LINE__);
        }
        $this->LastSchoolGradeGuid = $lastSchoolGradeGuid;
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllSchoolGrades_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Get SchoolId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolId()
    {
        return isset($this->SchoolId) ? $this->SchoolId : null;
    }
    /**
     * Set SchoolId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolId
     * @return \StructType\GetAllSchoolGrades_Options
     */
    public function setSchoolId($schoolId = null)
    {
        // validation for constraint: string
        if (!is_null($schoolId) && !is_string($schoolId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolId)), __LINE__);
        }
        if (is_null($schoolId) || (is_array($schoolId) && empty($schoolId))) {
            unset($this->SchoolId);
        } else {
            $this->SchoolId = $schoolId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllSchoolGrades_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
