<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllSchoolBoundaries.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllSchoolBoundaries.Options
 * @subpackage Structs
 */
class GetAllSchoolBoundaries_Options extends WebServiceRequestOptions
{
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastSchoolBoundaryId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSchoolBoundaryId;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * Constructor method for GetAllSchoolBoundaries.Options
     * @uses GetAllSchoolBoundaries_Options::setIncludeSpatialData()
     * @uses GetAllSchoolBoundaries_Options::setLastSchoolBoundaryId()
     * @uses GetAllSchoolBoundaries_Options::setPackageSize()
     * @param bool $includeSpatialData
     * @param string $lastSchoolBoundaryId
     * @param int $packageSize
     */
    public function __construct($includeSpatialData = null, $lastSchoolBoundaryId = null, $packageSize = null)
    {
        $this
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastSchoolBoundaryId($lastSchoolBoundaryId)
            ->setPackageSize($packageSize);
    }
    /**
     * Get IncludeSpatialData value
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return $this->IncludeSpatialData;
    }
    /**
     * Set IncludeSpatialData value
     * @param bool $includeSpatialData
     * @return \StructType\GetAllSchoolBoundaries_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        $this->IncludeSpatialData = $includeSpatialData;
        return $this;
    }
    /**
     * Get LastSchoolBoundaryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSchoolBoundaryId()
    {
        return isset($this->LastSchoolBoundaryId) ? $this->LastSchoolBoundaryId : null;
    }
    /**
     * Set LastSchoolBoundaryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSchoolBoundaryId
     * @return \StructType\GetAllSchoolBoundaries_Options
     */
    public function setLastSchoolBoundaryId($lastSchoolBoundaryId = null)
    {
        // validation for constraint: string
        if (!is_null($lastSchoolBoundaryId) && !is_string($lastSchoolBoundaryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastSchoolBoundaryId)), __LINE__);
        }
        if (is_null($lastSchoolBoundaryId) || (is_array($lastSchoolBoundaryId) && empty($lastSchoolBoundaryId))) {
            unset($this->LastSchoolBoundaryId);
        } else {
            $this->LastSchoolBoundaryId = $lastSchoolBoundaryId;
        }
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllSchoolBoundaries_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllSchoolBoundaries_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
