<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllPolicies.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllPolicies.Options
 * @subpackage Structs
 */
class GetAllPolicies_Options extends WebServiceRequestOptions
{
    /**
     * The GradeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeGuid;
    /**
     * The LastPolicyGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastPolicyGuid;
    /**
     * The Layer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Layer;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * Constructor method for GetAllPolicies.Options
     * @uses GetAllPolicies_Options::setGradeGuid()
     * @uses GetAllPolicies_Options::setLastPolicyGuid()
     * @uses GetAllPolicies_Options::setLayer()
     * @uses GetAllPolicies_Options::setPackageSize()
     * @param string $gradeGuid
     * @param string $lastPolicyGuid
     * @param int $layer
     * @param int $packageSize
     */
    public function __construct($gradeGuid = null, $lastPolicyGuid = null, $layer = null, $packageSize = null)
    {
        $this
            ->setGradeGuid($gradeGuid)
            ->setLastPolicyGuid($lastPolicyGuid)
            ->setLayer($layer)
            ->setPackageSize($packageSize);
    }
    /**
     * Get GradeGuid value
     * @return string|null
     */
    public function getGradeGuid()
    {
        return $this->GradeGuid;
    }
    /**
     * Set GradeGuid value
     * @param string $gradeGuid
     * @return \StructType\GetAllPolicies_Options
     */
    public function setGradeGuid($gradeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gradeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($gradeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gradeGuid) && !is_string($gradeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gradeGuid)), __LINE__);
        }
        $this->GradeGuid = $gradeGuid;
        return $this;
    }
    /**
     * Get LastPolicyGuid value
     * @return string|null
     */
    public function getLastPolicyGuid()
    {
        return $this->LastPolicyGuid;
    }
    /**
     * Set LastPolicyGuid value
     * @param string $lastPolicyGuid
     * @return \StructType\GetAllPolicies_Options
     */
    public function setLastPolicyGuid($lastPolicyGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastPolicyGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastPolicyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastPolicyGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastPolicyGuid) && !is_string($lastPolicyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPolicyGuid)), __LINE__);
        }
        $this->LastPolicyGuid = $lastPolicyGuid;
        return $this;
    }
    /**
     * Get Layer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLayer()
    {
        return isset($this->Layer) ? $this->Layer : null;
    }
    /**
     * Set Layer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $layer
     * @return \StructType\GetAllPolicies_Options
     */
    public function setLayer($layer = null)
    {
        // validation for constraint: int
        if (!is_null($layer) && !is_numeric($layer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($layer)), __LINE__);
        }
        if (is_null($layer) || (is_array($layer) && empty($layer))) {
            unset($this->Layer);
        } else {
            $this->Layer = $layer;
        }
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllPolicies_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllPolicies_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
