<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllExceptionBoundaryGrades StructType
 * @subpackage Structs
 */
class GetAllExceptionBoundaryGrades extends AbstractStructBase
{
    /**
     * The databaseGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $databaseGuid;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetAllExceptionBoundaryGrades_Options
     */
    public $options;
    /**
     * Constructor method for GetAllExceptionBoundaryGrades
     * @uses GetAllExceptionBoundaryGrades::setDatabaseGuid()
     * @uses GetAllExceptionBoundaryGrades::setOptions()
     * @param string $databaseGuid
     * @param \StructType\GetAllExceptionBoundaryGrades_Options $options
     */
    public function __construct($databaseGuid = null, \StructType\GetAllExceptionBoundaryGrades_Options $options = null)
    {
        $this
            ->setDatabaseGuid($databaseGuid)
            ->setOptions($options);
    }
    /**
     * Get databaseGuid value
     * @return string|null
     */
    public function getDatabaseGuid()
    {
        return $this->databaseGuid;
    }
    /**
     * Set databaseGuid value
     * @param string $databaseGuid
     * @return \StructType\GetAllExceptionBoundaryGrades
     */
    public function setDatabaseGuid($databaseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($databaseGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($databaseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($databaseGuid) && !is_string($databaseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseGuid)), __LINE__);
        }
        $this->databaseGuid = $databaseGuid;
        return $this;
    }
    /**
     * Get options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetAllExceptionBoundaryGrades_Options|null
     */
    public function getOptions()
    {
        return isset($this->options) ? $this->options : null;
    }
    /**
     * Set options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetAllExceptionBoundaryGrades_Options $options
     * @return \StructType\GetAllExceptionBoundaryGrades
     */
    public function setOptions(\StructType\GetAllExceptionBoundaryGrades_Options $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->options);
        } else {
            $this->options = $options;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllExceptionBoundaryGrades
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
