<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllDeadheads.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllDeadheads.Options
 * @subpackage Structs
 */
class GetAllDeadheads_Options extends WebServiceRequestOptions
{
    /**
     * The ComponentID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComponentID;
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastDeadheadGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastDeadheadGuid;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * Constructor method for GetAllDeadheads.Options
     * @uses GetAllDeadheads_Options::setComponentID()
     * @uses GetAllDeadheads_Options::setIncludeSpatialData()
     * @uses GetAllDeadheads_Options::setLastDeadheadGuid()
     * @uses GetAllDeadheads_Options::setPackageSize()
     * @uses GetAllDeadheads_Options::setRouteID()
     * @param string $componentID
     * @param bool $includeSpatialData
     * @param string $lastDeadheadGuid
     * @param int $packageSize
     * @param string $routeID
     */
    public function __construct($componentID = null, $includeSpatialData = null, $lastDeadheadGuid = null, $packageSize = null, $routeID = null)
    {
        $this
            ->setComponentID($componentID)
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastDeadheadGuid($lastDeadheadGuid)
            ->setPackageSize($packageSize)
            ->setRouteID($routeID);
    }
    /**
     * Get ComponentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComponentID()
    {
        return isset($this->ComponentID) ? $this->ComponentID : null;
    }
    /**
     * Set ComponentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $componentID
     * @return \StructType\GetAllDeadheads_Options
     */
    public function setComponentID($componentID = null)
    {
        // validation for constraint: string
        if (!is_null($componentID) && !is_string($componentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($componentID)), __LINE__);
        }
        if (is_null($componentID) || (is_array($componentID) && empty($componentID))) {
            unset($this->ComponentID);
        } else {
            $this->ComponentID = $componentID;
        }
        return $this;
    }
    /**
     * Get IncludeSpatialData value
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return $this->IncludeSpatialData;
    }
    /**
     * Set IncludeSpatialData value
     * @param bool $includeSpatialData
     * @return \StructType\GetAllDeadheads_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        $this->IncludeSpatialData = $includeSpatialData;
        return $this;
    }
    /**
     * Get LastDeadheadGuid value
     * @return string|null
     */
    public function getLastDeadheadGuid()
    {
        return $this->LastDeadheadGuid;
    }
    /**
     * Set LastDeadheadGuid value
     * @param string $lastDeadheadGuid
     * @return \StructType\GetAllDeadheads_Options
     */
    public function setLastDeadheadGuid($lastDeadheadGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastDeadheadGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastDeadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastDeadheadGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastDeadheadGuid) && !is_string($lastDeadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDeadheadGuid)), __LINE__);
        }
        $this->LastDeadheadGuid = $lastDeadheadGuid;
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllDeadheads_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Get RouteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteID()
    {
        return isset($this->RouteID) ? $this->RouteID : null;
    }
    /**
     * Set RouteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeID
     * @return \StructType\GetAllDeadheads_Options
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        if (is_null($routeID) || (is_array($routeID) && empty($routeID))) {
            unset($this->RouteID);
        } else {
            $this->RouteID = $routeID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllDeadheads_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
