<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllDeadheadWaypoints.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllDeadheadWaypoints.Options
 * @subpackage Structs
 */
class GetAllDeadheadWaypoints_Options extends WebServiceRequestOptions
{
    /**
     * The DeadheadGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeadheadGuid;
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastWaypointGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastWaypointGuid;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * Constructor method for GetAllDeadheadWaypoints.Options
     * @uses GetAllDeadheadWaypoints_Options::setDeadheadGuid()
     * @uses GetAllDeadheadWaypoints_Options::setIncludeSpatialData()
     * @uses GetAllDeadheadWaypoints_Options::setLastWaypointGuid()
     * @uses GetAllDeadheadWaypoints_Options::setPackageSize()
     * @param string $deadheadGuid
     * @param bool $includeSpatialData
     * @param string $lastWaypointGuid
     * @param int $packageSize
     */
    public function __construct($deadheadGuid = null, $includeSpatialData = null, $lastWaypointGuid = null, $packageSize = null)
    {
        $this
            ->setDeadheadGuid($deadheadGuid)
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastWaypointGuid($lastWaypointGuid)
            ->setPackageSize($packageSize);
    }
    /**
     * Get DeadheadGuid value
     * @return string|null
     */
    public function getDeadheadGuid()
    {
        return $this->DeadheadGuid;
    }
    /**
     * Set DeadheadGuid value
     * @param string $deadheadGuid
     * @return \StructType\GetAllDeadheadWaypoints_Options
     */
    public function setDeadheadGuid($deadheadGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deadheadGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($deadheadGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deadheadGuid) && !is_string($deadheadGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deadheadGuid)), __LINE__);
        }
        $this->DeadheadGuid = $deadheadGuid;
        return $this;
    }
    /**
     * Get IncludeSpatialData value
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return $this->IncludeSpatialData;
    }
    /**
     * Set IncludeSpatialData value
     * @param bool $includeSpatialData
     * @return \StructType\GetAllDeadheadWaypoints_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        $this->IncludeSpatialData = $includeSpatialData;
        return $this;
    }
    /**
     * Get LastWaypointGuid value
     * @return string|null
     */
    public function getLastWaypointGuid()
    {
        return $this->LastWaypointGuid;
    }
    /**
     * Set LastWaypointGuid value
     * @param string $lastWaypointGuid
     * @return \StructType\GetAllDeadheadWaypoints_Options
     */
    public function setLastWaypointGuid($lastWaypointGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastWaypointGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastWaypointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastWaypointGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastWaypointGuid) && !is_string($lastWaypointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastWaypointGuid)), __LINE__);
        }
        $this->LastWaypointGuid = $lastWaypointGuid;
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllDeadheadWaypoints_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllDeadheadWaypoints_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
