<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllCorners.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllCorners.Options
 * @subpackage Structs
 */
class GetAllCorners_Options extends WebServiceRequestOptions
{
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastCornerGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastCornerGuid;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * The Road1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Road1;
    /**
     * The Road2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Road2;
    /**
     * Constructor method for GetAllCorners.Options
     * @uses GetAllCorners_Options::setIncludeSpatialData()
     * @uses GetAllCorners_Options::setLastCornerGuid()
     * @uses GetAllCorners_Options::setPackageSize()
     * @uses GetAllCorners_Options::setRoad1()
     * @uses GetAllCorners_Options::setRoad2()
     * @param bool $includeSpatialData
     * @param string $lastCornerGuid
     * @param int $packageSize
     * @param string $road1
     * @param string $road2
     */
    public function __construct($includeSpatialData = null, $lastCornerGuid = null, $packageSize = null, $road1 = null, $road2 = null)
    {
        $this
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastCornerGuid($lastCornerGuid)
            ->setPackageSize($packageSize)
            ->setRoad1($road1)
            ->setRoad2($road2);
    }
    /**
     * Get IncludeSpatialData value
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return $this->IncludeSpatialData;
    }
    /**
     * Set IncludeSpatialData value
     * @param bool $includeSpatialData
     * @return \StructType\GetAllCorners_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        $this->IncludeSpatialData = $includeSpatialData;
        return $this;
    }
    /**
     * Get LastCornerGuid value
     * @return string|null
     */
    public function getLastCornerGuid()
    {
        return $this->LastCornerGuid;
    }
    /**
     * Set LastCornerGuid value
     * @param string $lastCornerGuid
     * @return \StructType\GetAllCorners_Options
     */
    public function setLastCornerGuid($lastCornerGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($lastCornerGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastCornerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($lastCornerGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastCornerGuid) && !is_string($lastCornerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCornerGuid)), __LINE__);
        }
        $this->LastCornerGuid = $lastCornerGuid;
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllCorners_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Get Road1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoad1()
    {
        return isset($this->Road1) ? $this->Road1 : null;
    }
    /**
     * Set Road1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $road1
     * @return \StructType\GetAllCorners_Options
     */
    public function setRoad1($road1 = null)
    {
        // validation for constraint: string
        if (!is_null($road1) && !is_string($road1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road1)), __LINE__);
        }
        if (is_null($road1) || (is_array($road1) && empty($road1))) {
            unset($this->Road1);
        } else {
            $this->Road1 = $road1;
        }
        return $this;
    }
    /**
     * Get Road2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoad2()
    {
        return isset($this->Road2) ? $this->Road2 : null;
    }
    /**
     * Set Road2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $road2
     * @return \StructType\GetAllCorners_Options
     */
    public function setRoad2($road2 = null)
    {
        // validation for constraint: string
        if (!is_null($road2) && !is_string($road2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road2)), __LINE__);
        }
        if (is_null($road2) || (is_array($road2) && empty($road2))) {
            unset($this->Road2);
        } else {
            $this->Road2 = $road2;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllCorners_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
