<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllAccessPoints.Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllAccessPoints.Options
 * @subpackage Structs
 */
class GetAllAccessPoints_Options extends WebServiceRequestOptions
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The IncludeSpatialData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSpatialData;
    /**
     * The LastAccessPointID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastAccessPointID;
    /**
     * The PackageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PackageSize;
    /**
     * The SchoolId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolId;
    /**
     * Constructor method for GetAllAccessPoints.Options
     * @uses GetAllAccessPoints_Options::setActive()
     * @uses GetAllAccessPoints_Options::setIncludeSpatialData()
     * @uses GetAllAccessPoints_Options::setLastAccessPointID()
     * @uses GetAllAccessPoints_Options::setPackageSize()
     * @uses GetAllAccessPoints_Options::setSchoolId()
     * @param bool $active
     * @param bool $includeSpatialData
     * @param string $lastAccessPointID
     * @param int $packageSize
     * @param string $schoolId
     */
    public function __construct($active = null, $includeSpatialData = null, $lastAccessPointID = null, $packageSize = null, $schoolId = null)
    {
        $this
            ->setActive($active)
            ->setIncludeSpatialData($includeSpatialData)
            ->setLastAccessPointID($lastAccessPointID)
            ->setPackageSize($packageSize)
            ->setSchoolId($schoolId);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \StructType\GetAllAccessPoints_Options
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get IncludeSpatialData value
     * @return bool|null
     */
    public function getIncludeSpatialData()
    {
        return $this->IncludeSpatialData;
    }
    /**
     * Set IncludeSpatialData value
     * @param bool $includeSpatialData
     * @return \StructType\GetAllAccessPoints_Options
     */
    public function setIncludeSpatialData($includeSpatialData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSpatialData) && !is_bool($includeSpatialData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSpatialData)), __LINE__);
        }
        $this->IncludeSpatialData = $includeSpatialData;
        return $this;
    }
    /**
     * Get LastAccessPointID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastAccessPointID()
    {
        return isset($this->LastAccessPointID) ? $this->LastAccessPointID : null;
    }
    /**
     * Set LastAccessPointID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastAccessPointID
     * @return \StructType\GetAllAccessPoints_Options
     */
    public function setLastAccessPointID($lastAccessPointID = null)
    {
        // validation for constraint: string
        if (!is_null($lastAccessPointID) && !is_string($lastAccessPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastAccessPointID)), __LINE__);
        }
        if (is_null($lastAccessPointID) || (is_array($lastAccessPointID) && empty($lastAccessPointID))) {
            unset($this->LastAccessPointID);
        } else {
            $this->LastAccessPointID = $lastAccessPointID;
        }
        return $this;
    }
    /**
     * Get PackageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPackageSize()
    {
        return isset($this->PackageSize) ? $this->PackageSize : null;
    }
    /**
     * Set PackageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $packageSize
     * @return \StructType\GetAllAccessPoints_Options
     */
    public function setPackageSize($packageSize = null)
    {
        // validation for constraint: int
        if (!is_null($packageSize) && !is_numeric($packageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageSize)), __LINE__);
        }
        if (is_null($packageSize) || (is_array($packageSize) && empty($packageSize))) {
            unset($this->PackageSize);
        } else {
            $this->PackageSize = $packageSize;
        }
        return $this;
    }
    /**
     * Get SchoolId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolId()
    {
        return isset($this->SchoolId) ? $this->SchoolId : null;
    }
    /**
     * Set SchoolId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schoolId
     * @return \StructType\GetAllAccessPoints_Options
     */
    public function setSchoolId($schoolId = null)
    {
        // validation for constraint: string
        if (!is_null($schoolId) && !is_string($schoolId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schoolId)), __LINE__);
        }
        if (is_null($schoolId) || (is_array($schoolId) && empty($schoolId))) {
            unset($this->SchoolId);
        } else {
            $this->SchoolId = $schoolId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllAccessPoints_Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
