<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GPSRouteVehicle StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GPSRouteVehicle
 * @subpackage Structs
 */
class GPSRouteVehicle extends AbstractStructBase
{
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The Platform
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Platform;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The RetireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RetireDate;
    /**
     * The RouteGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteGuid;
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The RouteVehicleGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RouteVehicleGuid;
    /**
     * The VehicleGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VehicleGuid;
    /**
     * The VehicleID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VehicleID;
    /**
     * Constructor method for GPSRouteVehicle
     * @uses GPSRouteVehicle::setEffectiveDate()
     * @uses GPSRouteVehicle::setPlatform()
     * @uses GPSRouteVehicle::setProvider()
     * @uses GPSRouteVehicle::setRetireDate()
     * @uses GPSRouteVehicle::setRouteGuid()
     * @uses GPSRouteVehicle::setRouteID()
     * @uses GPSRouteVehicle::setRouteVehicleGuid()
     * @uses GPSRouteVehicle::setVehicleGuid()
     * @uses GPSRouteVehicle::setVehicleID()
     * @param string $effectiveDate
     * @param string $platform
     * @param string $provider
     * @param string $retireDate
     * @param string $routeGuid
     * @param string $routeID
     * @param string $routeVehicleGuid
     * @param string $vehicleGuid
     * @param string $vehicleID
     */
    public function __construct($effectiveDate = null, $platform = null, $provider = null, $retireDate = null, $routeGuid = null, $routeID = null, $routeVehicleGuid = null, $vehicleGuid = null, $vehicleID = null)
    {
        $this
            ->setEffectiveDate($effectiveDate)
            ->setPlatform($platform)
            ->setProvider($provider)
            ->setRetireDate($retireDate)
            ->setRouteGuid($routeGuid)
            ->setRouteID($routeID)
            ->setRouteVehicleGuid($routeVehicleGuid)
            ->setVehicleGuid($vehicleGuid)
            ->setVehicleID($vehicleID);
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\GPSRouteVehicle
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get Platform value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlatform()
    {
        return isset($this->Platform) ? $this->Platform : null;
    }
    /**
     * Set Platform value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $platform
     * @return \StructType\GPSRouteVehicle
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: string
        if (!is_null($platform) && !is_string($platform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($platform)), __LINE__);
        }
        if (is_null($platform) || (is_array($platform) && empty($platform))) {
            unset($this->Platform);
        } else {
            $this->Platform = $platform;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \StructType\GPSRouteVehicle
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get RetireDate value
     * @return string|null
     */
    public function getRetireDate()
    {
        return $this->RetireDate;
    }
    /**
     * Set RetireDate value
     * @param string $retireDate
     * @return \StructType\GPSRouteVehicle
     */
    public function setRetireDate($retireDate = null)
    {
        // validation for constraint: string
        if (!is_null($retireDate) && !is_string($retireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retireDate)), __LINE__);
        }
        $this->RetireDate = $retireDate;
        return $this;
    }
    /**
     * Get RouteGuid value
     * @return string|null
     */
    public function getRouteGuid()
    {
        return $this->RouteGuid;
    }
    /**
     * Set RouteGuid value
     * @param string $routeGuid
     * @return \StructType\GPSRouteVehicle
     */
    public function setRouteGuid($routeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeGuid) && !is_string($routeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeGuid)), __LINE__);
        }
        $this->RouteGuid = $routeGuid;
        return $this;
    }
    /**
     * Get RouteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteID()
    {
        return isset($this->RouteID) ? $this->RouteID : null;
    }
    /**
     * Set RouteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeID
     * @return \StructType\GPSRouteVehicle
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        if (is_null($routeID) || (is_array($routeID) && empty($routeID))) {
            unset($this->RouteID);
        } else {
            $this->RouteID = $routeID;
        }
        return $this;
    }
    /**
     * Get RouteVehicleGuid value
     * @return string|null
     */
    public function getRouteVehicleGuid()
    {
        return $this->RouteVehicleGuid;
    }
    /**
     * Set RouteVehicleGuid value
     * @param string $routeVehicleGuid
     * @return \StructType\GPSRouteVehicle
     */
    public function setRouteVehicleGuid($routeVehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeVehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $routeVehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($routeVehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeVehicleGuid) && !is_string($routeVehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeVehicleGuid)), __LINE__);
        }
        $this->RouteVehicleGuid = $routeVehicleGuid;
        return $this;
    }
    /**
     * Get VehicleGuid value
     * @return string|null
     */
    public function getVehicleGuid()
    {
        return $this->VehicleGuid;
    }
    /**
     * Set VehicleGuid value
     * @param string $vehicleGuid
     * @return \StructType\GPSRouteVehicle
     */
    public function setVehicleGuid($vehicleGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vehicleGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($vehicleGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleGuid) && !is_string($vehicleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleGuid)), __LINE__);
        }
        $this->VehicleGuid = $vehicleGuid;
        return $this;
    }
    /**
     * Get VehicleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVehicleID()
    {
        return isset($this->VehicleID) ? $this->VehicleID : null;
    }
    /**
     * Set VehicleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vehicleID
     * @return \StructType\GPSRouteVehicle
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleID)), __LINE__);
        }
        if (is_null($vehicleID) || (is_array($vehicleID) && empty($vehicleID))) {
            unset($this->VehicleID);
        } else {
            $this->VehicleID = $vehicleID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GPSRouteVehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
