<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionBoundaryType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionBoundaryType
 * @subpackage Structs
 */
class ExceptionBoundaryType extends AbstractStructBase
{
    /**
     * The Alert
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alert;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Eligibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Eligibility;
    /**
     * The ExceptionBoundaryTypeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExceptionBoundaryTypeGuid;
    /**
     * The ExceptionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionType;
    /**
     * The Scope
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionBoundaryTypeScope
     */
    public $Scope;
    /**
     * The ScopeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScopeGuid;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * The TravelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TravelCode
     */
    public $TravelCode;
    /**
     * The TravelCodeGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TravelCodeGuid;
    /**
     * Constructor method for ExceptionBoundaryType
     * @uses ExceptionBoundaryType::setAlert()
     * @uses ExceptionBoundaryType::setDescription()
     * @uses ExceptionBoundaryType::setEligibility()
     * @uses ExceptionBoundaryType::setExceptionBoundaryTypeGuid()
     * @uses ExceptionBoundaryType::setExceptionType()
     * @uses ExceptionBoundaryType::setScope()
     * @uses ExceptionBoundaryType::setScopeGuid()
     * @uses ExceptionBoundaryType::setSortOrder()
     * @uses ExceptionBoundaryType::setTravelCode()
     * @uses ExceptionBoundaryType::setTravelCodeGuid()
     * @param string $alert
     * @param string $description
     * @param int $eligibility
     * @param string $exceptionBoundaryTypeGuid
     * @param string $exceptionType
     * @param \StructType\ExceptionBoundaryTypeScope $scope
     * @param string $scopeGuid
     * @param int $sortOrder
     * @param \StructType\TravelCode $travelCode
     * @param string $travelCodeGuid
     */
    public function __construct($alert = null, $description = null, $eligibility = null, $exceptionBoundaryTypeGuid = null, $exceptionType = null, \StructType\ExceptionBoundaryTypeScope $scope = null, $scopeGuid = null, $sortOrder = null, \StructType\TravelCode $travelCode = null, $travelCodeGuid = null)
    {
        $this
            ->setAlert($alert)
            ->setDescription($description)
            ->setEligibility($eligibility)
            ->setExceptionBoundaryTypeGuid($exceptionBoundaryTypeGuid)
            ->setExceptionType($exceptionType)
            ->setScope($scope)
            ->setScopeGuid($scopeGuid)
            ->setSortOrder($sortOrder)
            ->setTravelCode($travelCode)
            ->setTravelCodeGuid($travelCodeGuid);
    }
    /**
     * Get Alert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlert()
    {
        return isset($this->Alert) ? $this->Alert : null;
    }
    /**
     * Set Alert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alert
     * @return \StructType\ExceptionBoundaryType
     */
    public function setAlert($alert = null)
    {
        // validation for constraint: string
        if (!is_null($alert) && !is_string($alert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alert)), __LINE__);
        }
        if (is_null($alert) || (is_array($alert) && empty($alert))) {
            unset($this->Alert);
        } else {
            $this->Alert = $alert;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\ExceptionBoundaryType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Eligibility value
     * @return int|null
     */
    public function getEligibility()
    {
        return $this->Eligibility;
    }
    /**
     * Set Eligibility value
     * @param int $eligibility
     * @return \StructType\ExceptionBoundaryType
     */
    public function setEligibility($eligibility = null)
    {
        // validation for constraint: int
        if (!is_null($eligibility) && !is_numeric($eligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eligibility)), __LINE__);
        }
        $this->Eligibility = $eligibility;
        return $this;
    }
    /**
     * Get ExceptionBoundaryTypeGuid value
     * @return string|null
     */
    public function getExceptionBoundaryTypeGuid()
    {
        return $this->ExceptionBoundaryTypeGuid;
    }
    /**
     * Set ExceptionBoundaryTypeGuid value
     * @param string $exceptionBoundaryTypeGuid
     * @return \StructType\ExceptionBoundaryType
     */
    public function setExceptionBoundaryTypeGuid($exceptionBoundaryTypeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($exceptionBoundaryTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $exceptionBoundaryTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($exceptionBoundaryTypeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exceptionBoundaryTypeGuid) && !is_string($exceptionBoundaryTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionBoundaryTypeGuid)), __LINE__);
        }
        $this->ExceptionBoundaryTypeGuid = $exceptionBoundaryTypeGuid;
        return $this;
    }
    /**
     * Get ExceptionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionType()
    {
        return isset($this->ExceptionType) ? $this->ExceptionType : null;
    }
    /**
     * Set ExceptionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionType
     * @return \StructType\ExceptionBoundaryType
     */
    public function setExceptionType($exceptionType = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionType) && !is_string($exceptionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionType)), __LINE__);
        }
        if (is_null($exceptionType) || (is_array($exceptionType) && empty($exceptionType))) {
            unset($this->ExceptionType);
        } else {
            $this->ExceptionType = $exceptionType;
        }
        return $this;
    }
    /**
     * Get Scope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionBoundaryTypeScope|null
     */
    public function getScope()
    {
        return isset($this->Scope) ? $this->Scope : null;
    }
    /**
     * Set Scope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionBoundaryTypeScope $scope
     * @return \StructType\ExceptionBoundaryType
     */
    public function setScope(\StructType\ExceptionBoundaryTypeScope $scope = null)
    {
        if (is_null($scope) || (is_array($scope) && empty($scope))) {
            unset($this->Scope);
        } else {
            $this->Scope = $scope;
        }
        return $this;
    }
    /**
     * Get ScopeGuid value
     * @return string|null
     */
    public function getScopeGuid()
    {
        return $this->ScopeGuid;
    }
    /**
     * Set ScopeGuid value
     * @param string $scopeGuid
     * @return \StructType\ExceptionBoundaryType
     */
    public function setScopeGuid($scopeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($scopeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scopeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($scopeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($scopeGuid) && !is_string($scopeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scopeGuid)), __LINE__);
        }
        $this->ScopeGuid = $scopeGuid;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\ExceptionBoundaryType
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get TravelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TravelCode|null
     */
    public function getTravelCode()
    {
        return isset($this->TravelCode) ? $this->TravelCode : null;
    }
    /**
     * Set TravelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TravelCode $travelCode
     * @return \StructType\ExceptionBoundaryType
     */
    public function setTravelCode(\StructType\TravelCode $travelCode = null)
    {
        if (is_null($travelCode) || (is_array($travelCode) && empty($travelCode))) {
            unset($this->TravelCode);
        } else {
            $this->TravelCode = $travelCode;
        }
        return $this;
    }
    /**
     * Get TravelCodeGuid value
     * @return string|null
     */
    public function getTravelCodeGuid()
    {
        return $this->TravelCodeGuid;
    }
    /**
     * Set TravelCodeGuid value
     * @param string $travelCodeGuid
     * @return \StructType\ExceptionBoundaryType
     */
    public function setTravelCodeGuid($travelCodeGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($travelCodeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $travelCodeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($travelCodeGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($travelCodeGuid) && !is_string($travelCodeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelCodeGuid)), __LINE__);
        }
        $this->TravelCodeGuid = $travelCodeGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionBoundaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
